% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{HeliumFootballs}
\alias{HeliumFootballs}
\title{Punting helium- and air-filled footballs}
\format{
A data frame with 39 observations on the following 3 variables.
\describe{ 
\item{trial}{ trial number} 
\item{air}{ distance traveled by air-filled football (yards)} 
\item{helium}{ distance traveled by helium-filled football (yards)} }
}
\source{
These data are available from DASL, the data and story library
(\url{https://dasl.datadescription.com/}).
}
\description{
Two identical footballs, one air-filled and one helium-filled, were used
outdoors on a windless day at The Ohio State University's athletic complex.
Each football was kicked 39 times and the two footballs were alternated with
each kick. The experimenter recorded the distance traveled by each ball.
}
\examples{

data(HeliumFootballs)
gf_point(helium ~ air, data = HeliumFootballs)
gf_dhistogram( 
  ~ (helium - air), data = HeliumFootballs, 
  fill = ~ (helium > air),  bins = 15, boundary = 0 
)

}
\references{
Lafferty, M. B. (1993), "OSU scientists get a kick out of sports
controversy", \emph{The Columbus Dispatch} (November, 21, 1993), B7.
}
\keyword{datasets}
