% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_neg_pred_parity.R
\name{eval_neg_pred_parity}
\alias{eval_neg_pred_parity}
\title{Examine Negative Predictive Parity of a Model}
\usage{
eval_neg_pred_parity(
  data,
  outcome,
  group,
  probs,
  cutoff = 0.5,
  confint = TRUE,
  bootstraps = 2500,
  alpha = 0.05,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
protected attribute}

\item{outcome}{Name of the outcome variable, it must be binary}

\item{group}{Name of the protected attribute. Must consist of only two groups.}

\item{probs}{Name of the predicted outcome variable}

\item{cutoff}{Threshold for the predicted outcome, default is 0.5}

\item{confint}{Whether to compute 95\% confidence interval, default is TRUE}

\item{bootstraps}{Number of bootstrap samples, default is 2500}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Logical; if TRUE (default), prints a textual summary of the
fairness evaluation. Only works if \code{confint} is TRUE.}
}
\value{
A list containing the following elements:
\itemize{
\item NPV_Group1: Negative Predictive Value for the first group
\item NPV_Group2: Negative Predictive Value for the second group
\item NPV_Diff: Difference in Negative Predictive Value
\item NPV_Ratio: Ratio in Negative Predictive Value
If confidence intervals are computed (\code{confint = TRUE}):
\item NPV_Diff_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the difference in Negative Predictive
Value
\item NPV_Ratio_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the ratio in Negative Predictive
Value
}
}
\description{
This function evaluates \emph{negative predictive predictive parity}, a key fairness criterion that
compares the \emph{Negative Predictive Value (NPV)} between groups defined by a binary protected attribute.
In other words, it assesses whether, among individuals predicted to be negative,
the probability of being truly negative is equal across subgroups.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the protected attribute and day_28_flg as the outcome.
# We choose threshold = 0.41 so that the overall FPR is around 5\%.

# Evaluate Negative Predictive Parity
eval_neg_pred_parity(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred",
  cutoff = 0.41
)
}
}
\seealso{
\code{\link{eval_pos_pred_parity}}
}
