% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srh.effsize.R
\name{srh.effsize}
\alias{srh.effsize}
\title{SRH with effect sizes for two-factor designs}
\usage{
srh.effsize(formula, data, clamp0 = TRUE, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ A + B}.}

\item{data}{A \code{data.frame} containing all variables in \code{formula}.}

\item{clamp0}{Logical; if \code{TRUE} (default), negative eta^2_H is
truncated to 0 and epsilon^2_H truncated to the interval \eqn{[0, 1]}.}

\item{...}{Passed to \code{rcompanion::scheirerRayHare()}.}
}
\value{
A \code{data.frame} (classed as \code{c("srh_with_call","anova","data.frame")})
with the SRH table extended by columns:
\code{k}, \code{n}, \code{eta2H}, \code{eps2H}.
}
\description{
Extends \code{rcompanion::scheirerRayHare()} by adding popular
rank-based effect sizes for each SRH term: eta^2_H and epsilon^2_H,
and stores the original function call.
}
\details{
Let \eqn{H} be the SRH H-statistic for a given term, \eqn{n} the sample size
used by SRH (complete cases on \code{y} and factors), and \eqn{k} the number
of groups compared by that term (for interactions, the number of
observed combinations).

Effect sizes computed:
\itemize{
\item \strong{Eta^2_H}: \eqn{(H - k + 1) / (n - k)}.
\item \strong{Epsilon^2_H} (KW-like): \eqn{H * (n + 1) / (n^2 - 1)}.
}

The original call is stored as an attribute and can be retrieved with
\code{getCall()}.
}
\examples{
data(mimicry, package = "factorH")
res <- srh.effsize(liking ~ gender + condition, data = mimicry)
res
getCall(res)

}
