% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ufRisk-functions.R
\name{loss_functions,fEGarch_risk-method}
\alias{loss_functions,fEGarch_risk-method}
\title{Loss Function Calculation}
\usage{
\S4method{loss_functions}{fEGarch_risk}(object, penalty = 1e-04, ...)
}
\arguments{
\item{object}{an object of class \code{"fEGarch_risk"} as returned
by the model fitting functions of this package, for example
\code{\link{fEGarch}}.}

\item{penalty}{the penalty term to use in the opportunity cost terms.}

\item{...}{currently without use.}
}
\value{
Returns a list with the four elements \code{rlf}, \code{flf},
\code{alf} and \code{clf}, each lists with numeric vector
elements \code{VaR} and \code{ES}. The four elements correspond
to the regulatory loss function, the firm's loss function,
the adjusted loss function and the corrected loss function.
}
\description{
Compute loss function values given log-returns and corresponding
value at risk (VaR) and expected shortfall (ES) series.
}
\details{
Let \eqn{n \in \mathbb{N}} be the number of observations of a (log-)return
series \eqn{\{r_t\}}, \eqn{t=1,\dots,n}, and let \eqn{\text{VaR}_t} and
\eqn{\text{ES}_t} be the
estimated or forecasted VaR and ES (at some confidence level \eqn{\alpha}) at time
\eqn{t}, respectively. Such series are included in an object of class
\code{"fEGarch_risk"}. In the following, a risk measure at time \eqn{t} is
simply denoted by \eqn{\text{RM}_t} and can either mean
\eqn{\text{VaR}_t} or
\eqn{\text{ES}_t}.

Based on a calculated VaR and / or expected shortfall (ES), capital needs
to be held back following regulatory rules. Commonly, among many models
used for forecasting risk measures that fulfill regulatory conditions,
loss functions are computed that also consider opportunity costs in to
assess, what model that fulfills regulatory rules minimizes such loss
functions. Let \eqn{\Omega \geq 0} be the penalty term.

For all loss functions we have
\deqn{\text{LF}_i = \sum_{t=1}^{n} l_{t,i}, \hspace{3mm} i = 0,1,2,3,}
as the loss function with
\deqn{l_{t,i} = (\text{RM}_t - r_t)^2, \hspace{3mm} i = 0,1,2,3,}
for \eqn{r_t < \text{RM}_t}. They differ in how the case
\eqn{r_t \geq \text{RM}_t} is treated.

The regulatory loss function (\code{rlf}) uses \eqn{l_{t,0} = 0}.

The firm's loss function (Sarma et al., 2003) (\code{flf}) considers
\eqn{l_{t,1}=\Omega |\text{RM}_t|}.

The adjusted loss function (Abad et al., 2015) (\code{alf}) makes use
of \eqn{l_{t,2} = \Omega |\text{RM}_t - r_t|}.

The corrected loss function (Feng, forthcoming) (\code{clf}) has
\eqn{l_{t,3} = \Omega \text{min}\left(|\text{RM}_t - r_t|, |\text{RM}_t|\right)}.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
model <- fEGarch(egarch_spec(), rt, n_test = 250)
fcast <- predict_roll(model)
risk <- measure_risk(fcast, measure = c("VaR", "ES"), level = c(0.95, 0.975, 0.99))
loss_functions(risk)

}
\references{
\itemize{
\item{Abad, P., Muela, S. B., & Martín, C. L. (2015). The role of
the loss function in value-at-risk comparisons. The Journal of Risk
Model Validation, 9(1): 1-19. DOI: 10.21314/JRMV.2015.132.}
\item{Sarma, M., Thomas, S., & Shah, A. (2003). Selection of Value-at-Risk
models. Journal of Forecasting,
22(4): 337-358. DOI: 10.1002/for.868.}
}
}
