% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va_methods.R
\name{va_methods}
\alias{va_methods}
\alias{convertVA}
\alias{convertVA.quali}
\alias{convertVA.snellendec}
\alias{convertVA.snellen}
\alias{convertVA.logmar}
\alias{convertVA.etdrs}
\alias{convertVA.default}
\title{VA conversion methods}
\usage{
convertVA(x, ...)

\method{convertVA}{quali}(x, to, type, ...)

\method{convertVA}{snellendec}(x, to, type, ...)

\method{convertVA}{snellen}(x, to, type, smallstep, noplus, ...)

\method{convertVA}{logmar}(x, to, type, ...)

\method{convertVA}{etdrs}(x, to, type, ...)

\method{convertVA}{default}(x, to, ...)
}
\arguments{
\item{x}{vector of visual acuities}

\item{...}{further arguments passed to methods}

\item{to}{to which VA class to convert}

\item{type}{which snellen notation. One of "ft", "m" or "dec"}

\item{smallstep}{how plus/minus entries are evaluated. Default to
increase/decrease snellen fractions by lines. If TRUE, each snellen
optotype will be considered equivalent to 0.02 logmar or 1 ETDRS
letter (assuming 5 letters in a row in a chart)}

\item{noplus}{ignoring plus/minus entries and just returning the
snellen fraction. This overrides the smallstep argument.}
}
\value{
vector with visual acuity of class \code{va}. See also "VA classes"
}
\description{
S3 methods for VA conversion
}
\details{
VA can be snellen feet/meter/decimal, logMAR, ETDRS, or
"qualitative" (Counting fingers, etc.)
\itemize{
\item Snellen fractions need to be either form 6/x or 20/x
\item ETDRS must be between 0 and 100
\item logMAR must be between -0.3 and 3.0
\item Qualitative must be PL, LP, NLP, NPL, HM, CF (any case allowed)
}

Any element which is not recognized will be converted to NA
}
\section{Conversion}{

For other conversion and theory behind conversion rules see \link{va}
section VA conversion.
}

\section{plus/minus entries}{

The following rules for plus minus notations will be applied:
\itemize{
\item if entry -2 to +2 : take same Snellen value
\item if < -2 : take Snellen value one line below
\item if > +2: Snellen value one line above
}

Snellen are unfortunately often entered with "+/-", which is a
violation of a psychophysical method designed to assign one
unambiguous value to visual acuity, with
non-arbitrary thresholds based on psychometric functions. Therefore,
transforming "+/-" notation to actual results is in itself
problematic and the below suggestion to convert it will remain an
approximation to the most likely "true" result. Even more so, as the
given conditions should work for charts with
4 or 5 optotypes in a line, and visual acuity is not always tested
on such charts. Yet, I believe that the approach is still better than
just omitting the letters or (worse) assigning a missing value to those
entries.
}

\seealso{
Other VA converter: 
\code{\link{VAwrapper}},
\code{\link{plausibility_methods}},
\code{\link{snellen_steps}},
\code{\link{va}()},
\code{\link{va_mixed}()},
\code{\link{which_va}()}
}
\concept{VA converter}
\keyword{internal}
