% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg-helper.R
\name{psy_minw}
\alias{psy_minw}
\alias{psy_ds}
\title{Helper functions in accordance to PSY(2015)}
\usage{
psy_minw(n)

psy_ds(n, rule = 1, delta = 1)
}
\arguments{
\item{n}{A positive integer. The sample size.}

\item{rule}{Rule to compute the minimum duration of an episode (default: rule = 1,
where T denotes the sample size). Rule 1 corresponds to log(T), while rule 2 to log(T)/T.}

\item{delta}{Frequency-dependent parameter (default; delta = 1).
See details.}
}
\description{
\code{psy_minw} and \code{psy_ds} use the rules-of- thumb proposed by
Phillips et al. (2015) to compute the minimum window size and the
minimum duration of an episode of exuberance, respectively.
}
\details{
For the minimum duration period, \code{psy_ds} allows the user to choose from two rules:

\deqn{rule_1 = \delta \log(n) \quad\& \quad rule_2 = \delta \log(n)/n}{rule_1 = d*log(n) & rule 2 = d*log(n)/n}

\code{delta } depends on the frequency of the data and the minimal duration condition.
}
\examples{
psy_minw(100)
psy_ds(100)
}
\references{
Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for
Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the
S&P 500. International Economic Review, 56(4), 1043-1078.
}
