% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_over_groupsize.R
\name{simulate_twoway_nrange}
\alias{simulate_twoway_nrange}
\title{Simulated independent and repeated measures two-way experiments over a set of sample sizes}
\usage{
simulate_twoway_nrange(
  matrices_obj,
  nset,
  balanced = TRUE,
  group_size = NULL,
  loss = NULL,
  repeated_measurements = FALSE,
  distribution = "normal",
  skewness = 1,
  shape = 0,
  inferior_limit = -Inf,
  superior_limit = Inf,
  nsims = 200
)
}
\arguments{
\item{matrices_obj}{List - Output generated by \code{calculate_mean_matrix} that include cell mean and standard deviation matrices}

\item{nset}{Vector - If default values are used for both \code{balanced} and \code{group_size}, sample sizes to be used in simulations. If \code{balanced="FALSE"} and a matrix is provided to \code{group_size}, number to add to all elements of \code{group_size}.}

\item{balanced}{Logical - Whether the study will be performed with the same number of subjects in all groups. Default is \code{TRUE}. See 'details'.}

\item{group_size}{Matrix - Sample size for each condition (combination of factor levels). Only to be used when \code{balanced=FALSE}.}

\item{loss}{Character - Type of selection of subjects in groups that have less observations than \code{max(group_size)}. Possible values are "random" and "sequential". Ignored if \code{repeated_measurements=FALSE} or \code{balanced=TRUE}. See 'details'.}

\item{repeated_measurements}{Logical - Does the design have repeated measurements. Default is false.}

\item{distribution}{Character - Type of distribution to simulate. Possible values are 'normal', 'truncated.normal' or 'skewed'.}

\item{skewness}{Numeric - Momentum of distribution skewness, univariate distribution simulation.}

\item{shape}{Numeric - Degree of skewness in the distribution. May be a single value, have a length equal to the number of levels of any one of the factors or a length equal to the product of the length of each factor. For multivariate distribution simulations.}

\item{inferior_limit}{Numeric - Value of the lower bound for the truncated distribution, defaults to '-Inf'. Ignored if \code{distribution} is either "normal" or "skewed".}

\item{superior_limit}{Numeric - Value of the upper bound for the truncated distribution, defaults to 'Inf'. Ignored if \code{distribution} is either "normal" or "skewed".}

\item{nsims}{Integer - Number of iterations}
}
\value{
List with of \code{data.frame}s of simulated outcome values under different sample sizes. Each data.frame includes factor level labels, iteration number and sample size.
}
\description{
Wrapper for both independent and repeated measures two-way simulations. A vector of defined sample sizes is simulated under the
model provided.
}
\details{
For unbalanced independent measures designs, this function generates a simulation with 'max(group_size)' for all combinations of factors and then eliminates observations
at random in those factor combinations that have less participants or study subjects. This is also the behavior for unbalanced repeated measures designs when \code{loss="random"}.

For unbalanced repeated measures designs in which \code{loss="sequential"} the participants or subjects from the groups with less observations will be a subset of participants or
subjects of groups with more observations. The elimination strategy may not sound like the most efficient way to proceed, is quite fast anyhow.

The 'n' column in the output will reflect how many observations each factor combination has. This should match the input matrix.
}
\examples{
refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85
factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)
## Independent design
effects_treat_time <- calculate_mean_matrix(refmean = refmean,
                                            fAeffect = treateff,fBeffect = timeeff,
                                            nlfA = treatgroups, nlfB = timepoints,
                                            label_list = factors_levels_names)
## Inspect plot to check if matrices correspond to design
effects_treat_time$meansplot
n <- seq(from = 16, to = 24, by = 2)

## In this case, the default 'repeated_measurements', 'distribution' and options are used.
indep_simulation <- simulate_twoway_nrange(effects_treat_time, n)

## Simulate from a truncated distribution
indep_simulation_trunc <- simulate_twoway_nrange(matrices_obj = effects_treat_time, nset = n,
                          distribution="truncated.normal", inferior_limit= 0.8)

##randomly select iteration, select a condition
k <- sample(1:max(indep_simulation_trunc[[1]]$iteration), 1)
toviewdist <- indep_simulation_trunc[[1]]
toviewdist <- subset(toviewdist, iteration==k)
toviewdist <- subset(toviewdist, cond=="V6")
hist(toviewdist$y)

}
