% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2tex.R
\name{table2tex}
\alias{table2tex}
\alias{table2html}
\title{Export statistical output to HTML or Latex table}
\usage{
table2tex(
  x = NULL,
  file = "Rtable",
  type = "TEX",
  digits = 2,
  digitspvals = 2,
  trim.pval = 1e-16,
  summary = FALSE,
  standAlone = TRUE,
  add.rownames = FALSE,
  ...
)

table2html(...)
}
\arguments{
\item{x}{given R stats object or list of stats objects to export; if set to \code{NULL} 
the output of the previous R command will be exported.}

\item{file}{name of output file. The appropriate extension is added automatically.}

\item{type}{desired output type - \code{"TEX"} for Latex and \code{"HTML"} for HTML.}

\item{digits}{number of significant digits to show for all columns except
for the column with p values.}

\item{digitspvals}{number of significant digits to show for columns with p
values.}

\item{trim.pval}{a threshold below which the p-values are trimmed as 
"< \code{trim.pval}".}

\item{summary}{logical indicating whether or not to summarize data files.}

\item{standAlone}{logical indicating whether exported Latex code should be
standalone compilable, or whether it will be pasted into another document.}

\item{add.rownames}{logical indicating whether the names of the rows should be added
to the table (inserting a column before first column).}

\item{\dots}{extra options are passed on to stargazer.}
}
\value{
No return value
}
\description{
Export currently showing R stats object or stats object obj to a
HTML or Latex table
}
\details{
Objects that can be exported are all those supported by \code{\link[xtable]{xtable}}, 
\code{\link[broom]{tidy}} (see \code{\link{table2office}} for an extensive list of supported 
methods), or \code{\link[stargazer]{stargazer}}. The models supported by 
\code{\link[stargazer]{stargazer}} are:
\itemize{
\item \code{aftreg} (\code{eha})
\item \code{anova} (\code{stats})
\item \code{aov} (\code{stats})
\item \code{aovlist} (\code{stats})
\item \code{arima} (\code{stats}) 
\item \code{betareg} (\code{betareg})
\item \code{binaryChoice} (\code{sampleSelection})
\item \code{bj} (\code{rms})
\item \code{brglm} (\code{brglm}) 
\item \code{censReg} (\code{censReg})
\item \code{coeftest} (\code{lmtest})
\item \code{coxph} (\code{survival})
\item \code{coxreg} (\code{eha}) 
\item \code{clm} (\code{ordinal})
\item \code{clogit} (\code{survival})
\item \code{cph} (\code{rms})
\item \code{dynlm} (\code{dynlm})
\item \code{ergm} (\code{ergm})
\item \code{errorsarlm} (\code{spdev})
\item \code{felm} (\code{lfe})
\item \code{gam} (\code{mgcv})
\item \code{garchFit} (\code{fGarch})
\item \code{gee} (\code{gee})
\item \code{glm} (\code{stats})
\item \code{Glm} (\code{rms})
\item \code{glmer} (\code{lme4})
\item \code{glmrob} (\code{robustbase})
\item \code{gls} (\code{nlme})
\item \code{Gls} (\code{rms})
\item \code{gmm} (\code{gmm})
\item \code{heckit} (\code{sampleSelection})
\item \code{hetglm} (\code{glmx})
\item \code{hurdle} (\code{pscl})
\item \code{ivreg} (\code{AER})
\item \code{lagarlm} (\code{spdep})
\item \code{lm} (\code{stats})
\item \code{lme} (\code{nlme})
\item \code{lmer} (\code{lme4})
\item \code{lmrob} (\code{robustbase})
\item \code{lrm} (\code{rms})
\item \code{maBina} (\code{erer})
\item \code{mclogit} (\code{mclogit})
\item \code{mlogit} (\code{mlogit})
\item \code{mnlogit} (\code{mnlogit})
\item \code{mlreg} (\code{eha})
\item \code{multinom} (\code{nnet})
\item \code{nlme} (\code{nlme})
\item \code{nlmer} (\code{lme4})
\item \code{ols} (\code{rms})
\item \code{pgmm} (\code{plm})
\item \code{phreg} (\code{eha})
\item \code{plm} (\code{plm})
\item \code{pmg} (\code{plm})
\item \code{polr} (\code{MASS})
\item \code{psm} (\code{rms})
\item \code{rem.dyad} (\code{relevent})
\item \code{rlm} (\code{MASS})
\item \code{rq} (\code{quantreg})
\item \code{Rq} (\code{rms})
\item \code{selection} (\code{sampleSelection})
\item \code{svyglm} (\code{survey})
\item \code{survreg} (\code{survival})
\item \code{tobit} (\code{AER})
\item \code{weibreg} (\code{eha})
\item \code{zeroin} (\code{pscl})
\item \code{relogit} (\code{zelig})
\item \code{cloglog.net} (\code{zelig})
\item \code{gamma.net} (\code{zelig})
\item \code{probit.net} (\code{zelig}) 
\item \code{logit.net} (\code{zelig})
}
}
\section{Functions}{
\itemize{
\item \code{table2html()}: Export statistical output to HTML table

}}
\examples{
# Create a file name
filen <- tempfile(pattern = "table_aov") # or 
# filen <- paste("YOUR_DIR/table_aov")

# Generate ANOVA output
fit=aov(yield ~ block + N * P + K, data = npk) # 'npk' dataset from base 'datasets'
x=summary(fit)

# Export to Latex in standAlone format
if (interactive()) table2tex(x=x,file=filen) 
# Export to Latex to paste in tex document
summary(fit) # get output from the console
if (interactive()) table2tex(file=filen, standAlone = FALSE) 

# Export to HTML
if (interactive()) table2html(x=x,file=filen) # or 
summary(fit) # get output from the console
if (interactive()) table2html(file=filen) 
}
\seealso{
\code{\link{table2office}} ,\code{\link{table2ppt}}, \code{\link{table2doc}}, 
\code{\link[stargazer]{stargazer}}
}
\author{
Tom Wenseleers, Christophe Vanderaa
}
