% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-var.R
\name{add_var_random_int}
\alias{add_var_random_int}
\title{Add a random integer variable to dataset}
\usage{
add_var_random_int(
  data,
  name = "random_int",
  min_val = 1,
  max_val = 10,
  overwrite = TRUE,
  seed
)
}
\arguments{
\item{data}{A dataset}

\item{name}{Name of new variable (as string)}

\item{min_val}{Minimum random integers}

\item{max_val}{Maximum random integers}

\item{overwrite}{Can new random variable overwrite an existing variable in dataset?}

\item{seed}{Seed for random number generation (integer)}
}
\value{
Dataset containing new random variable
}
\description{
Add a random integer variable to dataset
}
\examples{
library(magrittr)
iris \%>\% add_var_random_int() \%>\% head()
iris \%>\% add_var_random_int(name = "random_var") \%>\% head()
iris \%>\% add_var_random_int(min_val = 1, max_val = 10) \%>\% head()
}
