% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttests.R
\name{ttests}
\alias{ttests}
\title{T-tests}
\usage{
ttests(ttest, elem = NULL, hyperloop = NULL)
}
\arguments{
\item{ttest}{ttest: the base result from a valid t-test generated by \code{\link[=ttest_num]{ttest_num()}}}

\item{elem}{character: element to extract (default: \code{NULL})}

\item{hyperloop}{named list: parameter values to run over (default: see above)}
}
\value{
A list of \code{ttest} objects is returned
}
\description{
\code{ttests} runs a variety of modifications to the input parameters of \code{ttest}, in order to generate all possible t-tests.
See under "Details" the detailed parameter values which are used. Note that not giving the parameter \code{hyperloop} will
results in approx. 5000 t-tests generated.
Returned will be only the different t-tests with the first element being \code{ttest}. If only a specific element of a \code{ttest}
is of interest then just give the name of the element in \code{elem} and then all \code{ttest}s will be returned where \code{elem} is different.
}
\details{
The default \code{hyperloop} is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(n           = c(1, ttest$n, ttest$n+1),
     mu0         = c(ttest$mu0, ttest$mean),
     mean        = c(ttest$mu0, ttest$mean), 
     sigma       = c(ttest$sigma, ttest$sd, sqrt(ttest$sigma), sqrt(ttest$sd)),
     sd          = c(ttest$sigma, ttest$sd, sqrt(ttest$sigma), sqrt(ttest$sd)),
     norm        = c(TRUE, FALSE),
     alpha       = unique(c(ttest$alpha, 0.01, 0.05, 0.1)),
     alternative = c("two.sided", "greater", "less")
    )
}\if{html}{\out{</div>}}
}
\examples{
basetest  <- ttest_num(mean=0.5, sd=1.25, n=50, sigma=1)
# vary the number of observations
hyperloop <- list(n=c(1, basetest$n, basetest$n^2))
# return all different t-tests
tts       <- ttests(basetest, hyperloop=hyperloop)
# return all different random sampling functions
ttests(basetest, "Xbar", hyperloop)
}
