% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumofsquares1.R
\name{sumofsquares1}
\alias{sumofsquares1}
\title{sumofsquares1}
\usage{
sumofsquares1(n2, nobs = 10, n = 0, x = runif(nobs), maxit = 1000)
}
\arguments{
\item{n2}{integer: number to decompose as sum of squares}

\item{nobs}{integer: length of return values}

\item{n}{integer: additional sum condition (default: \code{0})}

\item{x}{numeric: vector of \code{nobs} starting values (default: \code{runif(nobs)})}

\item{maxit}{integer: maximal number of iterations}
}
\value{
A integer vector of length \code{nobs}.
}
\description{
Decomposes an integer \code{n2} into a sum of squared integers (\eqn{n2 = \sum_{i=1}^{nobs} x_i^2}).
If \code{n} is not \code{NA} then it is ensured that \eqn{\sum_{i=1}^{nobs} x_i = 0}.
Note if \code{nobs<=10} then the following data sets are available:
\itemize{
\item \code{sos100=sumofsquares(100, 10, zerosum=TRUE, maxt=Inf)},
\item \code{sos200=sumofsquares(200, 10, zerosum=TRUE, maxt=Inf)},
\item \code{sos400=sumofsquares(400, 10, zerosum=TRUE, maxt=Inf)}, and
\item \code{sos800=sumofsquares(800, 10, zerosum=TRUE, maxt=Inf)}
}
}
\examples{
sumofsquares1(100, 20)
sumofsquares1(100, 20)
}
