% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histdata.R
\name{histdata}
\alias{histdata}
\alias{dhist}
\alias{quantile.histogram}
\alias{median.histogram}
\alias{mean.histogram}
\title{Histogram Data}
\usage{
histdata(x, breaks = "Sturges", probs = seq(0, 1, 0.25), ...)

\method{quantile}{histogram}(x, probs = seq(0, 1, 0.25), ...)

\method{median}{histogram}(x, ...)

\method{mean}{histogram}(x, ...)

dhist(x, breaks = "Sturges", probs = seq(0, 1, 0.25), ...)
}
\arguments{
\item{x}{numeric data or histogram data}

\item{breaks}{one of:
    \itemize{
      \item a vector giving the breakpoints between histogram cells,
      \item a function to compute the vector of breakpoints,
      \item a single number giving the number of cells for the histogram,
      \item a character string naming an algorithm to compute the
      number of cells (see \sQuote{Details}),
      \item a function to compute the number of cells.
    }
    In the last three cases the number is a suggestion only; as the
    breakpoints will be set to \code{\link{pretty}} values, the number
    is limited to \code{1e6} (with a warning if it was larger).  If
    \code{breaks} is a function, the \code{x} vector is supplied to it
    as the only argument (and the number of breaks is only limited by
    the amount of available memory).
  }

\item{probs}{numeric: probabilities to use if \code{breaks="Quantile"} (default: \code{seq(0, 1, 0.25)})}

\item{...}{further parameters used in \link[graphics:hist]{graphics::hist}}
}
\value{
Like in \link[graphics:hist]{graphics::hist}, but with this additional list of elements:
\itemize{
\item \code{lower} lower class borders,
\item \code{upper} upper class borders,
\item \code{width} class widths,
\item \code{relfreq} the relative class frequency,
\item \code{cumfbrk} the cumulated relative frequency of the \code{breaks},
\item \code{maxdens} the indices of the maximal \code{density} values,
\item \code{maxcount} the indices of the maximal \code{count} values
\item \code{x} the original finite data, and
\item \code{class} the class number for each value in \code{x}.
}
}
\description{
Returns data for a histogram. Calls internally \code{hist(..., plot=FALSE)}.
\itemize{
\item \code{mean} returns the mean of the data.
\item \code{quantile} and \code{median} return the quantile(s) or median with an attribute \code{pos}, the class number of the quantile(s), or the median.
}
}
\examples{
#1
x <- seq(0, 1, by=0.25)
print(hist(x, plot=FALSE))
histdata(x)
#2
x <- seq(0, 1, by=0.25)
print(hist(x, x, plot=FALSE))
histdata(x, x)
#3
print(hist(x, x, right=FALSE, plot=FALSE))
histdata(x, x, right=FALSE)
}
