% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremes.R
\name{extremes}
\alias{extremes}
\title{Extremes}
\usage{
extremes(p, type = c("all", "minimum", "maximum", "saddle"), tol = 1e-09)
}
\arguments{
\item{p}{a polynomial}

\item{type}{character: either \code{all} (default), \code{minimum}, \code{maximum}, or \code{saddle}}

\item{tol}{numeric: if the absolute value of the imaginary part of the zeroes of the derivative of \code{p} is
smaller than \code{tol}, it will be considered as zero}
}
\value{
A numeric vector.
}
\description{
Computes the real valued extremes (minima, maxima, and saddle points) for a univariate polynomial.
The computation can be limited to a specific type of extremes.
}
\examples{
p <- polynomial(c(0,0,0,1))
extremes(p)
p <- integral(poly.calc(-1:1))
extremes(p)
}
