% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_content_length}
\alias{get_content_length}
\title{Get the content length of a file to download}
\usage{
get_content_length(api, file_to_download)
}
\arguments{
\item{api}{An endpoint to the dataset variants.}

\item{file_to_download}{A character vector of file names to download.}
}
\value{
An integer vector of content lengths, named by the file names.
}
\description{
This function retrieves the content length of a file
to be downloaded from the API.
}
\examples{
api <- get_topic("Postal")
files <- get_latest_files(api)$csv
purrr::map(
  files,
  get_content_length,
  api = api) |>
  tibble::as_tibble()
}
