data("mpdta", package = "did")
# Add exponeniated employment outcome (for Poisson)
mpdta$emp = exp(mpdta$lemp)

# Known outputs ----

# from etwfe(...) |> fixest::coeftable() |> dput()

m1_known = structure(
  c(
    -0.0193723636759116,
    -0.0783190990620529,
    -0.136078114440309,
    -0.104707471576594,
    0.00251386194191313,
    -0.0391927355917248,
    -0.0431060328087001,
    0.0223952764912568,
    0.030506236091693,
    0.0354768817979489,
    0.0338947465597152,
    0.0199448451562706,
    0.0240232361043774,
    0.0184422693090335,
    -0.865020071686749,
    -2.56731439521572,
    -3.83568418485349,
    -3.08919470432157,
    0.126040684809366,
    -1.63145112596148,
    -2.33734970932159,
    0.387443428108348,
    0.010539223223148,
    0.000141260031324757,
    0.0021189122536199,
    0.899750485829418,
    0.103426076960745,
    0.0198154873775247
  ),
  dim = c(7L, 4L),
  dimnames = list(
    c(
      ".Dtreat:first.treat::2004:year::2004",
      ".Dtreat:first.treat::2004:year::2005",
      ".Dtreat:first.treat::2004:year::2006",
      ".Dtreat:first.treat::2004:year::2007",
      ".Dtreat:first.treat::2006:year::2006",
      ".Dtreat:first.treat::2006:year::2007",
      ".Dtreat:first.treat::2007:year::2007"
    ),
    c("Estimate", "Std. Error", "t value", "Pr(>|t|)")
  ),
  type = "Clustered (countyreal)"
)

m2_known = structure(
  c(
    -0.0105032462209509,
    -0.0704231581031381,
    -0.137258738889396,
    -0.100811363085397,
    -0.00376929367371485,
    0.00275081875051886,
    -0.00459460695286396,
    -0.041224471546218,
    0.00330635669251332,
    0.033813012275807,
    0.0310871193896906,
    -0.0260544107191967,
    0.0233633078987137,
    0.0311343819027016,
    0.0366116000064794,
    0.0345251351219756,
    0.0314933678411734,
    0.0196530028296998,
    0.0178409306056071,
    0.0203268606975245,
    0.0245699429153858,
    0.0212312006908406,
    0.0179638358765074,
    0.0167358589135634,
    -0.449561606022801,
    -2.26190962528879,
    -3.74905054313674,
    -2.9199411596576,
    -0.119685315737715,
    0.139969386579531,
    -0.257531798897304,
    -2.02807861772962,
    0.13456916460489,
    1.59260951691698,
    1.73053904541321,
    -1.55680152741257,
    0.653221784531605,
    0.0241324067083723,
    0.000198289769460991,
    0.00365931411401919,
    0.904780603080407,
    0.888740655516229,
    0.796874436233205,
    0.0430829502415971,
    0.89300678247844,
    0.111881039660844,
    0.0841522334691531,
    0.120151588094448
  ),
  dim = c(12L, 4L),
  dimnames = list(
    c(
      ".Dtreat:first.treat::2004:year::2004",
      ".Dtreat:first.treat::2004:year::2005",
      ".Dtreat:first.treat::2004:year::2006",
      ".Dtreat:first.treat::2004:year::2007",
      ".Dtreat:first.treat::2006:year::2003",
      ".Dtreat:first.treat::2006:year::2004",
      ".Dtreat:first.treat::2006:year::2006",
      ".Dtreat:first.treat::2006:year::2007",
      ".Dtreat:first.treat::2007:year::2003",
      ".Dtreat:first.treat::2007:year::2004",
      ".Dtreat:first.treat::2007:year::2005",
      ".Dtreat:first.treat::2007:year::2007"
    ),
    c("Estimate", "Std. Error", "t value", "Pr(>|t|)")
  ),
  type = "Clustered (countyreal)"
)

m3_known = structure(
  c(
    1.06546108405747,
    0.0509823826985821,
    -0.041095431207238,
    0.0555183938817427,
    0.011013688481133,
    0.0207333310655632,
    0.0105353915454823,
    0.0209209626492697,
    -0.0212480022225509,
    -0.0818499992698647,
    -0.137870386660852,
    -0.10953945536511,
    0.00253680638189265,
    -0.04509347225369,
    -0.0459545277368072,
    0.00462780039742067,
    0.0251130755098969,
    0.0507345526392162,
    0.0112496795427671,
    0.0389351822929353,
    0.0380597297024231,
    -0.0198351447054503,
    0.0218237817228486,
    0.0377557671485909,
    0.047389569045131,
    0.0392123848205692,
    0.00755374493475534,
    0.0081044417942881,
    0.0108156893383766,
    0.0118083552383958,
    0.0217240175852948,
    0.0273693782016555,
    0.0307883605600032,
    0.0323152812535003,
    0.0188790276715869,
    0.0219826417092899,
    0.017971446660356,
    0.0175803616035178,
    0.0179002505276808,
    0.0210659128405859,
    0.0266117743663025,
    0.0164685801973129,
    0.0224724271460086,
    0.0161949112478703,
    48.8211024829843,
    1.35032040265364,
    -0.867183053893171,
    1.41583823926516,
    1.45804347065761,
    2.55826762556007,
    0.974084149042659,
    1.77170844092187,
    -0.978088060328856,
    -2.99056846183351,
    -4.47800351019529,
    -3.38971072248505,
    0.134371665004261,
    -2.05132180426856,
    -2.55708561504847,
    0.263236928897677,
    1.40294547671622,
    2.40837190503656,
    0.422733162694036,
    2.36421001849863,
    1.6936190049762,
    -1.22477637585441,
    3.60917549867772e-192,
    0.177525332281026,
    0.386258526050651,
    0.157446722604435,
    0.145457634902087,
    0.0108136889419664,
    0.330486713933036,
    0.0770531943021735,
    0.328504711370681,
    0.00292217673304545,
    9.34688069979038e-06,
    0.000755092602385005,
    0.893162865039634,
    0.0407571269913775,
    0.0108500161606811,
    0.792476627011191,
    0.161254985185557,
    0.0163854271665081,
    0.672672060931325,
    0.0184505761455979,
    0.0909617659690022,
    0.221237342285313
  ),
  dim = c(22L, 4L),
  dimnames = list(
    c(
      "lpop",
      "first.treat::2004:lpop",
      "first.treat::2006:lpop",
      "first.treat::2007:lpop",
      "year::2004:lpop",
      "year::2005:lpop",
      "year::2006:lpop",
      "year::2007:lpop",
      ".Dtreat:first.treat::2004:year::2004",
      ".Dtreat:first.treat::2004:year::2005",
      ".Dtreat:first.treat::2004:year::2006",
      ".Dtreat:first.treat::2004:year::2007",
      ".Dtreat:first.treat::2006:year::2006",
      ".Dtreat:first.treat::2006:year::2007",
      ".Dtreat:first.treat::2007:year::2007",
      ".Dtreat:first.treat::2004:year::2004:lpop_dm",
      ".Dtreat:first.treat::2004:year::2005:lpop_dm",
      ".Dtreat:first.treat::2004:year::2006:lpop_dm",
      ".Dtreat:first.treat::2004:year::2007:lpop_dm",
      ".Dtreat:first.treat::2006:year::2006:lpop_dm",
      ".Dtreat:first.treat::2006:year::2007:lpop_dm",
      ".Dtreat:first.treat::2007:year::2007:lpop_dm"
    ),
    c("Estimate", "Std. Error", "t value", "Pr(>|t|)")
  ),
  type = "Clustered (countyreal)"
)

m3p_known = structure(
  c(
    2.4844551064551,
    1.03962548577062,
    -0.0132715527271909,
    -0.0811734279004765,
    0.0162898970653376,
    -0.00661180654034027,
    -0.00774015772960484,
    -0.00907715098669154,
    -0.00358620129108189,
    0.23610760399351,
    0.59270500533805,
    -0.144050148824302,
    -0.0105492949463896,
    0.0112893423156783,
    0.0453898278318641,
    0.0542583782980444,
    -0.0309556552918575,
    -0.0662240386949426,
    -0.132971344933512,
    -0.117022779216096,
    -0.00904940559832479,
    -0.0681486377022154,
    -0.0399915656289664,
    0.0118797980184146,
    0.0209935307380792,
    0.0409103313957724,
    0.0250348138419749,
    0.0375837523432487,
    0.045380425307866,
    -0.0109675422750577,
    0.0774941076110031,
    0.0168639979795991,
    0.0404687165556241,
    0.0330063208795569,
    0.0250987946626758,
    0.00451266221672394,
    0.0059153496433499,
    0.00653603193006326,
    0.00548454234216233,
    0.20791803023313,
    0.177065839969024,
    0.122377001945353,
    0.0209057606267668,
    0.0270396824995217,
    0.029156323478846,
    0.028005001016106,
    0.0176207591941838,
    0.0255833352827062,
    0.0237253169390011,
    0.022500568035011,
    0.0244213099833293,
    0.025111336200421,
    0.0168249306911585,
    0.00712853782256276,
    0.0119250403862843,
    0.00957137590131348,
    0.0112873223993356,
    0.0136182842946466,
    0.0164515507677572,
    0.0072256336356803,
    32.0599227869854,
    61.647628695656,
    -0.327945975478349,
    -2.45932978100425,
    0.649031050465628,
    -1.46516761565643,
    -1.30848693590013,
    -1.38878620603735,
    -0.653874301145061,
    1.13558022711533,
    3.34737070369835,
    -1.17710146951163,
    -0.5046118691746,
    0.41751016550871,
    1.55677473755551,
    1.93745318083866,
    -1.75677193875252,
    -2.58856157585163,
    -5.60461827656033,
    -5.20088110815728,
    -0.370553651892637,
    -2.7138594759873,
    -2.37692305323921,
    1.66651258843202,
    1.76045783142379,
    4.27423724839375,
    2.21795860490779,
    2.75980083320943,
    2.7584284271125,
    -1.51786581330387,
    1.59672190513747e-225,
    0,
    0.742952510856085,
    0.0139196688647647,
    0.516318306487623,
    0.142875192673417,
    0.190708202795485,
    0.164897770988907,
    0.513192791975142,
    0.256132288002404,
    0.00081582034832112,
    0.239155008649015,
    0.613831471709541,
    0.676305290381574,
    0.119523977066787,
    0.052689971231527,
    0.0789566899295247,
    0.00963777141561626,
    2.08714427199854e-08,
    1.98345957029263e-07,
    0.710970008505917,
    0.00665043702379681,
    0.0174577294585615,
    0.095611363005707,
    0.0783302112799688,
    1.9179273009909e-05,
    0.0265576550069098,
    0.00578366096099526,
    0.00580800222819492,
    0.129048229767705
  ),
  dim = c(30L, 4L),
  dimnames = list(
    c(
      "(Intercept)",
      "lpop",
      "first.treat::2004:lpop",
      "first.treat::2006:lpop",
      "first.treat::2007:lpop",
      "year::2004:lpop",
      "year::2005:lpop",
      "year::2006:lpop",
      "year::2007:lpop",
      "first.treat::2004",
      "first.treat::2006",
      "first.treat::2007",
      "year::2004",
      "year::2005",
      "year::2006",
      "year::2007",
      ".Dtreat:first.treat::2004:year::2004",
      ".Dtreat:first.treat::2004:year::2005",
      ".Dtreat:first.treat::2004:year::2006",
      ".Dtreat:first.treat::2004:year::2007",
      ".Dtreat:first.treat::2006:year::2006",
      ".Dtreat:first.treat::2006:year::2007",
      ".Dtreat:first.treat::2007:year::2007",
      ".Dtreat:first.treat::2004:year::2004:lpop_dm",
      ".Dtreat:first.treat::2004:year::2005:lpop_dm",
      ".Dtreat:first.treat::2004:year::2006:lpop_dm",
      ".Dtreat:first.treat::2004:year::2007:lpop_dm",
      ".Dtreat:first.treat::2006:year::2006:lpop_dm",
      ".Dtreat:first.treat::2006:year::2007:lpop_dm",
      ".Dtreat:first.treat::2007:year::2007:lpop_dm"
    ),
    c("Estimate", "Std. Error", "z value", "Pr(>|z|)")
  ),
  type = "Clustered (countyreal)"
)


# Tests ----

# No controls
m1 = etwfe(
  lemp ~ 0,
  tvar = year,
  gvar = first.treat,
  data = mpdta,
  vcov = ~countyreal
)
m1a = etwfe(
  lemp ~ 0,
  tvar = "year",
  gvar = "first.treat",
  data = mpdta,
  vcov = ~countyreal
) # chars instead of nse
m1r = etwfe(
  lemp ~ 0,
  tvar = "year",
  gvar = "first.treat",
  data = mpdta,
  vcov = ~countyreal,
  gref = 0
) # with explicit ref

expect_equal(fixest::coeftable(m1), m1_known)
expect_equal(fixest::coeftable(m1a), m1_known)
expect_equal(fixest::coeftable(m1r), m1_known)

# With never-treated control group
m2 = etwfe(
  lemp ~ 0,
  tvar = year,
  gvar = first.treat,
  data = mpdta,
  vcov = ~countyreal,
  cgroup = "never"
)

expect_equal(fixest::coeftable(m2), m2_known)

# With control
m3 = etwfe(
  lemp ~ lpop,
  tvar = year,
  gvar = first.treat,
  data = mpdta,
  vcov = ~countyreal
)
expect_equal(fixest::coeftable(m3), m3_known)

expect_error(
  etwfe(lemp ~ 0, tvar = NULL, gvar = first.treat, data = mpdta)
)

# Poisson version
m3p = etwfe(
  emp ~ lpop,
  tvar = year,
  gvar = first.treat,
  data = mpdta,
  vcov = ~countyreal,
  family = "poisson"
)
expect_equal(fixest::coeftable(m3p), m3p_known)
