% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_dose_selector.R
\name{get_random_selector}
\alias{get_random_selector}
\title{Get an object to fit a dose-selector that randomly selects doses.}
\usage{
get_random_selector(
  parent_selector_factory = NULL,
  prob_select,
  supports_efficacy = FALSE,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just select random doses from the
start.}

\item{prob_select}{vector of probabilities, the probability of selecting
dose 1...n}

\item{supports_efficacy}{TRUE to monitor toxicity and efficacy outcomes;
FALSE (by default) to just monitor toxicity outcomes.}

\item{...}{Extra args are ignored.}
}
\value{
an object of type \code{\link{selector_factory}}.
}
\description{
Get an object to fit a dose-selector that randomly selects doses. Whilst this
design is unlikely to pass the ethical hurdles when investigating truly
experimental treatments, this class is useful for illustrating methods and
can be useful for benchmarking.
}
\examples{
prob_select = c(0.1, 0.3, 0.5, 0.07, 0.03)
model <- get_random_selector(prob_select = prob_select)
fit <- model \%>\% fit('1NTN')
fit \%>\% recommended_dose() # This is random
# We could also precede this selector with a set path:
model <- follow_path('1NN 2NN 3NN') \%>\%
  get_random_selector(prob_select = prob_select)
fit <- model \%>\% fit('1NN')
fit \%>\% recommended_dose() # This is not-random; it comes from the path.
fit <- model \%>\% fit('1NN 2NT')
fit \%>\% recommended_dose() # This is random; the path is discarded.
}
