% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boin12_selector.R
\name{get_boin12}
\alias{get_boin12}
\title{Get an object to fit the BOIN12 model for phase I/II dose-finding.}
\usage{
get_boin12(
  num_doses,
  phi_t,
  phi_e,
  u1 = 100,
  u2,
  u3,
  u4 = 0,
  n_star = 6,
  c_t = 0.95,
  c_e = 0.9,
  start_dose = 1,
  prior_alpha = 1,
  prior_beta = 1,
  ...
)
}
\arguments{
\item{num_doses}{integer, num of doses under investigation}

\item{phi_t}{Probability of toxicity threshold}

\item{phi_e}{Probability of efficacy threshold}

\item{u1}{utility of efficacy without toxicity, 100 by default}

\item{u2}{utility of no efficacy and no toxicity, between u1 and u4}

\item{u3}{utility of efficacy and toxicity, between u1 and u4}

\item{u4}{utility of toxicity without efficacy , 0 by default}

\item{n_star}{when tox is within bounds, stop exploring higher doses when n
at dose is greater than or equal to this value. 6 by default.}

\item{c_t}{certainty required to flag excess toxicity, 0.95 by default}

\item{c_e}{certainty required to flag deficient efficacy, 0.9 by default}

\item{start_dose}{index of starting dose, 1 by default (i.e. lowest dose)}

\item{prior_alpha}{first shape param for prior on beta prior, 1 by default}

\item{prior_beta}{second shape param for prior on beta prior, 1 by default}

\item{...}{Extra args are passed onwards.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
BOIN12 model to outcomes.
}
\description{
This function returns an object that can be used to fit the BOIN12 model for
phase I/II dose-finding, i.e. it selects doses according to efficacy and
toxicity outcomes.
}
\examples{
# Examples in Lin et al.
model <- get_boin12(num_doses = 5, phi_t = 0.35, phi_e = 0.25,
                    u2 = 40, u3 = 60, n_star = 6)
fit <- model \%>\% fit('1NNN 2ENT 3ETT 2EEN')
fit \%>\% recommended_dose()
fit \%>\% continue()
fit \%>\% is_randomising()
fit \%>\% dose_admissible()
fit \%>\% prob_administer()

}
\references{
Lin, R., Zhou, Y., Yan, F., Li, D., & Yuan, Y. (2020).
BOIN12: Bayesian optimal interval phase I/II trial design for utility-based
dose finding in immunotherapy and targeted therapies.
JCO precision oncology, 4, 1393-1402.
}
