% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_last_dose_to_cohort.R
\name{expand_last_dose_to_cohort}
\alias{expand_last_dose_to_cohort}
\title{Expand the cohort of the last given dose to at least n patients}
\usage{
expand_last_dose_to_cohort(parent_selector_factory, n)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{n}{Continue at current dose until at least n patients are evaluated.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
Expand the cohort of the last given dose to at least n patients
}
\examples{
model <- follow_path(path = "1N 2N 3N") \%>\%
  expand_last_dose_to_cohort(n = 3)
x <- model \%>\% fit("1N 2N 3T")
# Design will continue:
continue(x)
# at dose 3:
recommended_dose(x)
# because it is expanding the last dose to a cohort of three.
}
