% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{gwb1dsp-ergmTerm}
\alias{gwb1dsp-ergmTerm}
\alias{InitErgmTerm.gwb1dsp}
\title{Geometrically weighted dyadwise shared partner distribution for dyads in the first bipartition}
\usage{
# binary: gwb1dsp(decay=0, fixed=FALSE, cutoff=30)
}
\arguments{
\item{decay}{nonnegative decay parameter for the shared partner counts; required if \code{fixed=TRUE} and ignored with a warning otherwise.}

\item{fixed}{optional argument indicating
whether the \code{decay} parameter is fixed at the given value, or is to be fit as a curved
exponential-family model (see Hunter and Handcock, 2006). The
default is \code{FALSE} , which means the scale parameter is not
fixed and thus the model is a curved exponential family.}

\item{cutoff}{This optional argument sets the number of underlying b1dsp terms
to use in computing the statistics when \code{fixed=FALSE}, in order to reduce
the computational burden.  Its default value can also be controlled by the
\code{gw.cutoff} term option control parameter. (See \code{?control.ergm}.)}
}
\description{
This term adds one network statistic to the model equal to the geometrically
weighted dyadwise shared partner distribution for dyads in the first bipartition with decay parameter
\code{decay} parameter, which should be non-negative. This term can only be used with bipartite networks.
}
\note{
This term takes an additional term option (see
\code{\link[=ergm-options]{options?ergm}}), \code{cache.sp}, controlling whether
the implementation will cache the number of shared partners for
each dyad in the network; this is usually enabled by default.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "gwb1dsp", "subsection")}
}
\concept{bipartite}
\concept{curved}
\concept{undirected}
