% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R
\name{F-ergmTerm}
\alias{F-ergmTerm}
\alias{InitErgmTerm.F}
\title{Filtering on arbitrary one-term model}
\usage{
# binary: F(formula, filter)
}
\arguments{
\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula with the terms to be evaluated}

\item{filter}{must contain one binary \code{ergm} term, with
the following properties:
\itemize{
\item dyadic independence;
\item dyadwise contribution of 0 for a 0-valued dyad.
}

Formally, this means that it is expressable as
\deqn{g(y) = \sum_{i,j} f_{i,j}(y_{i,j}),}{sum[i,j]
  f[i,j] (y[i,j]),} where for all \eqn{i}, \eqn{j}, and \eqn{y},
\eqn{f_{i,j}(y_{i,j})} for which \eqn{f_{i,j}(0)=0}{f[i,j] (0)=0}.
For convenience, the term in specified can be a part of a simple logical or comparison operation: (e.g., \code{~!nodematch("A")} or \code{~abs("X")>3}),
which filters on \eqn{f_{i,j}(y_{i,j}) \bigcirc 0}{f[i,j] (y[i,j]) \%OP\% 0} instead.}
}
\description{
Evaluates the given \code{formula} on a network constructed by
taking \eqn{y} and removing any edges for which
\eqn{f_{i,j}(y_{i,j}) = 0}{f[i,j] (y[i,j])=0} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "F", "subsection")}
}
\concept{operator}
