% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doThePlotDrugVectors.R
\name{createTanimotoBaseline}
\alias{createTanimotoBaseline}
\title{Creates the plot for all jaccard coefficients amongst the three epilepsy ontologies}
\usage{
createTanimotoBaseline(neuroepso, neuroesso, neuroepi, dneuromaxk)
}
\arguments{
\item{neuroepso}{list of neuro drug names co-occurring with epso}

\item{neuroesso}{list of neuro drug names co-occurring with esso}

\item{neuroepi}{list of neuro drug names co-occurring with epi}

\item{dneuromaxk}{object returned from TopKLists::calculate.maxk}
}
\value{
jaccardepilepsyplot the ggplot object
}
\description{
Creates the plot for all jaccard coefficients amongst the three epilepsy ontologies
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
atchashda <-
  readAtcMapIntoHashMapDrugNamesAtcCodes(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashaa <-
  readAtcMapIntoHashMapAtcCodesAtcNames(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashsec <-
  readSecondLevelATC(
    system.file("extdata", "atc-secondlevel.map", package = "epos"), "\t")
tepso <- rawDrugNamesCoOcEpSO
tesso <- rawDrugNamesCoOcESSO
tepi <- rawDrugNamesCoOcEPILONT
tepisem <- rawDrugNamesCoOcEPISEM
tfenics <- rawDrugNamesCoOcFENICS

neuroepso <- filterNeuroDrugs(tepso, atchashda)
neuroesso <- filterNeuroDrugs(tesso, atchashda)
neuroepi <- filterNeuroDrugs(tepi, atchashda)
neuroepisem <- filterNeuroDrugs(tepisem, atchashda)
neurofenics <- filterNeuroDrugs(tfenics, atchashda)

dneuro <-
  data.frame(EpSO = neuroepso[1:210],
             ESSO = neuroesso[1:210],
             EPILONT = neuroepi[1:210],
             EPISEM = neuroepisem[1:210],
             FENICS = neurofenics[1:210])
dneuromaxk <- TopKLists::calculate.maxK(dneuro, 5, 5, 5)
tanimotobaseline <- createTanimotoBaseline(neuroepso, neuroesso, neuroepi, dneuromaxk)
}
