% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.glm.R
\name{get_information_function.glm}
\alias{get_information_function.glm}
\title{Function to compute/extract a function that returns the information
matrix for an object of class \code{glm}/\code{enriched_glm}}
\usage{
\method{get_information_function}{glm}(object, ...)
}
\arguments{
\item{object}{an object of class \code{glm} or\code{enriched_glm}}

\item{...}{currently not used}
}
\description{
Function to compute/extract a function that returns the information
matrix for an object of class \code{glm}/\code{enriched_glm}
}
\details{
The computed/extracted function has arguments
\describe{

\item{coefficients}{the regression coefficients at which the
information matrix is evaluated. If missing then the maximum
likelihood estimates are used}

\item{dispersion}{the dispersion parameter at which the information
matrix is evaluated. If missing then the maximum likelihood estimate
is used}

\item{type}{should the function return the 'expected' or 'observed' information? Default is \code{expected}}

\item{QR}{If \code{TRUE}, then the QR decomposition of \deqn{W^{1/2} X} is returned, where \deqn{W} is a diagonal matrix with the working weights (\code{object$weights}) and \deqn{X} is the model matrix.}

\item{CHOL}{If \code{TRUE}, then the Cholesky decomposition of the information matrix at the coefficients is returned}

}
}
