% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.enspls.R
\name{print.enspls.fs}
\alias{print.enspls.fs}
\title{Print enspls.fs Object}
\usage{
\method{print}{enspls.fs}(x, sort = TRUE, nvar = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{enspls.fs}.}

\item{sort}{Should the variables be sorted in decreasing order of importance?}

\item{nvar}{Number of top variables to show. Ignored if \code{sort = FALSE}.}

\item{...}{Additional parameters for \code{\link{print}}.}
}
\description{
Print enspls.fs object.
}
\examples{
data("logd1k")
x <- logd1k$x
y <- logd1k$y

set.seed(42)
fs <- enspls.fs(
  x, y,
  reptimes = 5, maxcomp = 3,
  alpha = c(0.3, 0.6, 0.9)
)
print(fs, nvar = 10L)
}
\seealso{
See \code{\link{enspls.fs}} for measuring feature importance with
ensemble sparse partial least squares regressions.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
