% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-annotations_crud.R
\name{update_itemsInLevel}
\alias{update_itemsInLevel}
\title{Update items programmatically}
\usage{
update_itemsInLevel(
  emuDBhandle,
  itemsToUpdate,
  rewriteAllAnnots = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \link{load_emuDB}}

\item{itemsToUpdate}{A data frame with the columns:
\itemize{
\item \code{session} (character)
\item \code{bundle} (character)
\item \code{level} (character)
\item \code{start_item_seq_idx} (character)
\item \code{attribute} (character)
\item \code{labels} (character)
}}

\item{rewriteAllAnnots}{should changes be written to file system (_annot.json
files) (intended for expert use only)}

\item{verbose}{if set to \code{TRUE}, more status messages are printed}
}
\description{
Update annotation items programmatically. You have to pass in a
data frame, called \code{itemsToUpdate}, describing the new state of the items.
The required columns are described below.

This function belongs to emuR’s CRUD family of functions, which let the user
manipulate items programmatically:
\itemize{
\item Create items (\link{create_itemsInLevel})
\item Read items (\link{query})
\item Update items (\link{update_itemsInLevel})
\item Delete items (\link{delete_itemsInLevel}))
}
}
