% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/referenceEnvelopes.R
\encoding{UTF-8}
\name{referenceEnvelopes}
\alias{referenceEnvelopes}
\alias{trajectoryEnvelopeVariability}
\alias{stateEnvelopeVariability}
\alias{compareToStateEnvelope}
\alias{compareToTrajectoryEnvelope}
\title{Ecological quality assessment}
\usage{
trajectoryEnvelopeVariability(
  d,
  sites,
  surveys = NULL,
  envelope = NULL,
  nboot.ci = NULL,
  alpha.ci = 0.05,
  ...
)

stateEnvelopeVariability(d, envelope = NULL, nboot.ci = NULL, alpha.ci = 0.05)

compareToTrajectoryEnvelope(
  d,
  sites,
  envelope,
  surveys = NULL,
  m = 1.5,
  comparison_target = "trajectories",
  distances_to_envelope = FALSE,
  distance_percentiles = FALSE,
  ...
)

compareToStateEnvelope(
  d,
  envelope,
  m = 1.5,
  nboot.ci = NULL,
  alpha.ci = 0.05,
  distances_to_envelope = FALSE,
  distance_percentiles = FALSE,
  ...
)
}
\arguments{
\item{d}{A symmetric \code{\link{matrix}} or an object of class \code{\link{dist}} containing the distance values between pairs of ecological states (see details).}

\item{sites}{A vector indicating the site corresponding to each ecological state.}

\item{surveys}{A vector indicating the survey corresponding to each ecological state (only necessary when surveys are not in order).}

\item{envelope}{A vector indicating the set of sites that conform the reference envelope (other sites will be compared to the envelope)}

\item{nboot.ci}{Number of bootstrap samples for confidence intervals. If nboot.ci = NULL then confidence intervals are not estimated.}

\item{alpha.ci}{Error in confidence intervals.}

\item{...}{Additional parameters for function \code{\link{trajectoryDistances}}}

\item{m}{Fuzziness exponent for quality value assessment}

\item{comparison_target}{String indicating the component to be compared to the reference envelope. Either 'trajectories' (to compare complete trajectories) or 'states' (to compare individual trajectory states).}

\item{distances_to_envelope}{Flag to indicate that distances to envelope should be included in the result}

\item{distance_percentiles}{Flag to include the percentage of distances to the envelope (among sites corresponding to the reference) that are smaller than that of the site.}
}
\value{
\itemize{
\item{Functions \code{stateEnvelopeVariability} and \code{trajectoryEnvelopeVariability} are used to assess the variability of reference envelopes.}
\item{Functions \code{compareToStateEnvelope} and \code{compareToTrajectoryEnvelope} return data frame with columns identifying the envelope and the Q statistic for the ecological quality with respect to the
envelope. If \code{nboot.ci != NULL} extra columns are added to indicate the boundaries of a confidence interval for Q, built
using bootstrap samples of the reference envelope.}
}
}
\description{
Functions to assess the variability of ecological reference envelopes and to assess the ecological quality of
target stations/observations with respect to reference envelopes (Sturbois et al., under review).
}
\details{
Functions \code{stateEnvelopeVariability} and \code{trajectoryEnvelopeVariability} are used to assess the
variability of reference envelopes. Functions \code{compareToStateEnvelope} and \code{compareToTrajectoryEnvelope} are
used to evaluate the ecological quality of stations/observations with respect to a predefined reference envelope.
}
\examples{
data(glomel)
 
# Extract compositional data matrix
glomel_comp <- as.matrix(glomel[,!(names(glomel) \%in\% c("ID", "Ref", "Complementary"))])
rownames(glomel_comp) <- glomel$ID
 
# Calculate Bray-Curtis distance matrix 
glomel_bc <- vegan::vegdist(glomel_comp, method = "bray")
 
# Define reference envelope (5 stations) by observation ID
glomel_env <- glomel$ID[glomel$Ref]
 
# Assess quality with respect to reference envelope
compareToStateEnvelope(glomel_bc, glomel_env)

}
\references{
Sturbois, A., De \enc{Cáceres}{Caceres}, M., Bifolchi, A., Bioret, F., \enc{Boyé}{Boye}, A., Gauthier, O., Grall, J., \enc{Grémare}{Gremare}, A., Labrune, C.,
Robert, A., Schaal, G., Desroy, N. (2023). Ecological Quality Assessment: a general multivariate framework to report
the quality of ecosystems and their dynamics with respect to reference conditions. Ecosphere.
}
\seealso{
\code{\link{trajectoryMetrics}}, \code{\link{glomel}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF

Anthony Sturbois, Vivarmor nature, \enc{Réserve}{Reserve} Naturelle nationale de la Baie de Saint-Brieuc
}
