% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weather_stations}
\alias{weather_stations}
\title{Australian Weather Station Metadata}
\format{
A tibble with 732 rows and 7 variables:
\describe{
  \item{ws_id}{Weather station ID (e.g., "941000-99999")}
  \item{stname}{Station name (e.g., "KALUMBURU")}
  \item{stn_lat}{Latitude of the station (decimal degrees)}
  \item{stn_lon}{Longitude of the station (decimal degrees)}
  \item{address}{Full geocoded address (from reverse geocoding)}
  \item{stn_city}{Parsed city or locality name}
  \item{stn_state}{Australian state or territory}
}
}
\source{
GSOD inventory via \pkg{GSODR}; geocoded with OpenStreetMap
}
\usage{
weather_stations
}
\description{
This dataset contains metadata for 732 weather stations across Australia,
including coordinates, station names, and geocoded location details.
}
\details{
This data was derived from the GSOD inventory using the \pkg{GSODR} package,
filtered for Australian stations, and geocoded using OpenStreetMap APIs. It is
used to match ecological observations with relevant local weather conditions.
}
\examples{
data(weather_stations)
head(weather_stations)
}
\seealso{
\code{\link{weather}}, \code{\link{top_stations}}, \code{\link{gouldian_finch}}
}
\keyword{datasets}
