% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{orchids}
\alias{orchids}
\title{Orchid Occurrence Data (2014–2024)}
\format{
A tibble with 302,123 rows and 14 variables:
\describe{
  \item{obs_lat}{Latitude of the observation (decimal degrees)}
  \item{obs_lon}{Longitude of the observation (decimal degrees)}
  \item{date}{Date of the observation (YYYY-MM-DD)}
  \item{time}{Time of the observation (HH:MM:SS)}
  \item{year}{Year of the observation}
  \item{month}{Month (1–12)}
  \item{day}{Day of the month}
  \item{hour}{Hour extracted from the time (0–23)}
  \item{weekday}{Day of the week (as ordered factor)}
  \item{dayofyear}{Day of the year (1–366)}
  \item{sci_name}{Scientific name of the observed orchid species}
  \item{record_type}{Type of observation (e.g., HUMAN_OBSERVATION, PRESERVED_SPECIMEN)}
  \item{obs_state}{Australian state where the observation occurred (may be missing)}
  \item{ws_id}{Nearest weather station ID linked to the observation}
}
}
\source{
Atlas of Living Australia via \pkg{galah}
}
\usage{
orchids
}
\description{
This dataset contains over 300,000 occurrence records of orchid species (*Orchidaceae*)
in Australia from 2014 to 2024. The data includes spatial, temporal, and taxonomic
details, as well as associated weather station metadata for ecological analysis.
}
\details{
The data was collected using the \pkg{galah} package from the Atlas of Living Australia,
cleaned, and linked to nearby weather stations for ecological and climatic studies.
The records span multiple orchid genera and include a range of observation types.
}
\examples{
data(orchids)
head(orchids)
}
\seealso{
\code{\link{glowworms}}, \code{\link{gouldian_finch}}, \code{\link{weather}}
}
\keyword{datasets}
