% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HSIplotter.R
\name{HSIplotter}
\alias{HSIplotter}
\title{Plots habitat suitability index curves}
\usage{
HSIplotter(SI, figure.name)
}
\arguments{
\item{SI}{matrix of suitability curves ordered as parameter breakpoints and
associated suitability indices for each parameter with appropriate column names.}

\item{figure.name}{output figure file name structured as "filename.jpeg".}
}
\value{
A multi-panel *.jpeg figure showing all suitability curves.
}
\description{
\code{HSIplotter} plots all suitability curves.
}
\examples{
#Build and define a matrix of the Barred Owl suitability curves
#Allen A.W. 1982. Habitat Suitability Index Models: Barred owl. FWS/OBS 82/10.143.
#U.S. Fish and Wildlife Service. https://pubs.er.usgs.gov/publication/fwsobs82_10_143.
var1 <- cbind(c(0,2,4,NA), c(0.1,1,1,NA)) #Number of trees > 51cm diameter per 0.4 ha plot
var2 <- cbind(c(0,5,20,NA), c(0,0,1,NA)) #Mean diameter of overstory trees
var3 <- cbind(c(0,20,60,100), c(0,0,1,1)) #Percent canopy cover of overstory trees
barredowl <- cbind(var1, var2, var3)
colnames(barredowl)<- c("tree.num", "tree.num.SIV",
  "avg.dbh.in", "avg.dbh.SIV", "can.cov", "can.cov.SIV")

#Create suitability curve summary plot
HSIplotter(barredowl, tempfile("BarredOwl",fileext=".jpeg"))

}
\references{
US Fish and Wildlife Service. (1980). Habitat as a basis for environmental assessment.
Ecological Services Manual, 101.

US Fish and Wildlife Service. (1980). Habitat Evaluation Procedures (HEP).
Ecological Services Manual, 102.

US Fish and Wildlife Service. (1981). Standards for the Development of
Habitat Suitability Index Models. Ecological Services Manual, 103.
}
