% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_legend}
\alias{e_legend}
\title{Legend}
\usage{
e_legend(e, show = TRUE, type = c("plain", "scroll"), icons = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{show}{Set to \code{FALSE} to hide the legend.}

\item{type}{Type of legend, \code{plain} or \code{scroll}.}

\item{icons}{A optional list of icons the same length as there are series, see example.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Customise the legend.
}
\examples{
e <- cars |>
  e_charts(speed) |>
  e_scatter(dist, symbol_size = 5)

# with legend
e

# without legend
e |>
  e_legend(show = FALSE)

# with icon
# path is taken from http://svgicons.sparkk.fr/
path <- paste0(
  "path://M11.344,5.71c0-0.73,0.074-1.122,1.199-1.122",
  "h1.502V1.871h-2.404c-2.886,0-3.903,1.36-3.903,3.646",
  "v1.765h-1.8V10h1.8v8.128h3.601V10h2.403l0.32-2.718h",
  "-2.724L11.344,5.71z"
)

e |>
  e_legend(
    icons = list(path)
  )
}
\seealso{
\href{https://echarts.apache.org/en/option.html#legend}{Additional arguments}
}
