% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_consist.R
\name{validate_consistency_tbl}
\alias{validate_consistency_tbl}
\title{Validate internal consistency table}
\usage{
validate_consistency_tbl(data, consis_tbl)
}
\arguments{
\item{data}{data frame which will be checked for internal consistency}

\item{consis_tbl}{data frame or tibble containing information on internal
consistency rules (see "Consistency Table Requirements" section)}
}
\value{
Error message or successful validation message is printed.
  The dataset is returned invisibly.
}
\description{
Runs a series of checks on a table of internal consistency rules
(see Consistency Table Requirements) in preparation for \code{\link{identify_inconsistency}}.
}
\section{Consistency Table Requirements}{
 Table must have exactly five character columns.
  The columns should be ordered according to the list below which describes the
  values of each column:
  \enumerate{
  \item First column name of data values that will be subject to 
  consistency checking. String. Required.
  \item Second column name of data values that will be subject to 
  consistency checking. String. Required.
  \item Logical test to compare columns one and two. One of: ">",">=",
  "<","<=","==", "!=". String. Optional if columns 4 and 5 have non-\code{NA} values.
  \item Either a single character string or a colon-separated range of
  numbers which should only appear in column A. Optional if column 3 has a
  non-\code{NA} value.
  \item Either a single character string or a colon-separated range of
  numbers which should only appear in column B given the value/range
  specified in column 4. Optional if column 3 has a non-\code{NA} value.
  }
  Each row should detail one test to make.
  Therefore, either column 3 or columns 4 and 5 must contain non-\code{NA}
  values.
}

\examples{
require(tibble)
# example with synthetic dataset on number of bean counters
# there is a lot going on in the function so a simple dataset aids this example
#
# creating `data`:
beans <- tibble::tibble(red_beans = 1:15,
blue_beans = 1:15,
total_beans = 1:15*2,
red_bean_summary = c(rep("few_beans",9), rep("many_beans",6)))
#
# creating `consis_tbl`
bean_rules <- tibble::tribble(~varA, ~varB, ~lgl_test, ~varA_boundaries, ~varB_boundaries,
"red_beans", "blue_beans", "==", NA, NA,
"red_beans", "total_beans", "<=", NA,NA,
"red_beans", "red_bean_summary", NA, "1:9", "few_beans",
"red_beans", "red_bean_summary", NA, "10:15", "many_beans")

validate_consistency_tbl(beans, bean_rules)
}
\seealso{
Other internal consistency functions: 
\code{\link{identify_inconsistency}()}
}
\concept{internal consistency functions}
