% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_review.R
\name{report_var_mods}
\alias{report_var_mods}
\title{Track changes to dataset variables}
\usage{
report_var_mods(before_tbl = NULL, after_tbl = NULL)
}
\arguments{
\item{before_tbl}{Data frame from before modifications were made.}

\item{after_tbl}{Data frame from after modifications were made.}
}
\value{
Tibble containing two columns. `variable` contains name of each
  variable. `presence` contains the presence of the variable in
  \code{after_tbl}.
}
\description{
Reports if variables have been added, removed, or are preserved between two
data frames. Intended to be used to review quality control / data
preparation.
}
\examples{
example_data_merged <- merge_cols(example_data, diabetes_type,
diabetes, "diabetes_merged", rm_in_vars = TRUE)

report_var_mods(example_data, example_data_merged)
}
