% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_export.R
\name{assume_var_classes}
\alias{assume_var_classes}
\title{Assume variable classes in data}
\usage{
assume_var_classes(data, out_file = NULL)
}
\arguments{
\item{data}{data frame}

\item{out_file}{file where variables and their assumed classes are stored for
user verification.}
}
\value{
Writes a .csv file containing the variables and their assumed 
data types / classes.
}
\description{
Classes/data types of data variables are assumed with this function and
exported to a .csv file for amendment. Any incorrect classes can then be
corrected and imported using \code{\link{import_var_classes}}.
}
\examples{
# example below assumes incorrectly for several variables
tmp = tempfile(fileext = ".csv")
data(example_data)
assume_var_classes(example_data, tmp)
}
\seealso{
\code{\link[eHDPrep]{import_var_classes}}
}
