% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata.R
\name{fdata}
\alias{fdata}
\title{Transform datasets for factor copula modeling}
\usage{
fdata(
  data,
  coord,
  grid = NULL,
  neigh = NULL,
  theta0 = NULL,
  cellsize = c(0.5, 0.5),
  parallel = TRUE,
  ncpus = 4,
  mc.set.seed = TRUE,
  ...
)
}
\arguments{
\item{data}{A matrix or data.frame. Each column corresponds to a station, with rows containing observations (on the original scale).}

\item{coord}{A two-column matrix or data frame of station coordinates (longitude and latitude), one row per station.}

\item{grid}{Optional two-column matrix or data frame of grid locations (longitude, latitude) at which the model will be fitted. If \code{NULL} (default), a regular grid is generated based on \code{cellsize}.}

\item{neigh}{Optional list of neighborhood station indices for each grid point. If \code{NULL}, neighborhoods
are constructed using \code{\link[=neighborhood_HT]{neighborhood_HT()}}.}

\item{theta0}{Optional matrix or data.frame with two columns: initial lambda and delta. Must match number of stations.}

\item{cellsize}{Numeric vector of length 1 or 2, specifying longitude and latitude resolution.}

\item{parallel}{Logical; if \code{TRUE}, run neighbourhood selection in parallel using \pkg{pbmcapply}.
On Windows, \code{pbmclapply} will fall back to serial execution (progress still shown).}

\item{ncpus}{Integer; number of worker processes when \code{parallel = TRUE} on Unix-alikes.}

\item{mc.set.seed}{Logical; seed the RNG streams in workers (default \code{TRUE}).
Effective on Unix-alikes; on Windows (serial fallback) it has no effect.}

\item{...}{Additional arguments passed to \code{\link[=neighborhood_HT]{neighborhood_HT()}}.}
}
\value{
An object of class \code{"fdata"}, which is a list with elements:
\item{data}{Original input data}
\item{coord}{Coordinates of stations}
\item{grid}{Grid points with assigned IDs}
\item{neigh}{List of neighbor station indices per grid point}
\item{theta0}{Initial values matrix}
\item{N}{Number of stations}
}
\description{
Prepares and organizes datasets for use with the exponential Factor Copula Model (eFCM). The function converts raw station-level observations and their spatial coordinates into an "fdata" object, which contains the data, grid structure, and neighborhood information required for model fitting with \code{fcm()}.
}
\examples{
\donttest{
# Load precipitation data for counterfactual scenarios
data("counterfactual")
data("LonLat")
coord = LonLat  # station coordinates (longitude-latitude)
cf_data <- fdata(counterfactual, coord, cellsize = c(1, 1))
}
}
\seealso{
\code{\link[=fcm]{fcm()}}, \code{\link[=neighborhood_HT]{neighborhood_HT()}}
}
