% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{roc}
\alias{roc}
\title{Roc curve}
\usage{
roc(response, scores, target = "1")
}
\arguments{
\item{response}{is the response variable vector}

\item{scores}{is the probability vector of the prediction}

\item{target}{is the target response class}
}
\value{
an object.
}
\description{
Computes and plots the Receiver Operating Characteristic (ROC) curve for a binary classification model,
along with the Area Under the Curve (AUC). The ROC curve is a graphical representation of a classifier’s
performance across all classification thresholds.
}
\examples{
\donttest{
## Classification:
data(iris)

# Create training and validation set:
smp_size <- floor(0.75 * nrow(iris))
train_ind <- sample(seq_len(nrow(iris)), size = smp_size)
training <- iris[train_ind, ]
validation <- iris[-train_ind, ]
response_training <- training[,5]
response_validation <- validation[,5]

# Perform training:
ensemble <- randomForest::randomForest(Species ~ ., data=training, 
importance=TRUE, proximity=TRUE)

D <- createDisMatrix(ensemble, data=training, label = "Species", 
                            parallel = list(active=FALSE, no_cores = 1))

setting=list(impTotal=0.1, maxDec=0.01, n=2, level=5)
tree <- e2tree(Species ~ ., training, D, ensemble, setting)

pr <- ePredTree(tree, validation, target="setosa")

roc(response_training, scores = pr$score, target = "setosa")
 
}

}
