% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{NonlinearDFAsim}
\alias{NonlinearDFAsim}
\title{Simulated multi-subject time series based on a dynamic factor analysis model with nonlinear relations at the latent level}
\format{A data frame with 3000 rows and 8 variables}
\usage{
data(NonlinearDFAsim)
}
\description{
A dataset simulated using a discrete-time nonlinear dynamic factor analysis model
with 6 observed indicators for identifying two latent factors: individuals'
positive and negative emotions. Proposed by Chow and Zhang (2013), the model was inspired 
by models of affect and it posits that the two latent factors follow a vector autoregressive
process of order 1 (VAR(1)) with parameters that vary between two possible regimes:
(1) an "independent" regime in which the lagged influences between positive and negative
emotions are zero; (2) a "high-activation" regime to capture instances
on which the lagged influences between PA and NA intensify when an individual's previous 
levels of positive and negative emotions were unusually high or low (see Model 2 in Chow & Zhang).
 
 Reference:
 Chow, S-M, & Zhang, G. (2013). Regime-switching nonlinear dynamic factor analysis 
 models. Psychometrika, 78(4), 740-768.
}
\details{
\itemize{
  \item id. ID of the participant (1 to 10)
  \item time. Time index (300 time points from each subject)
  \item y1-y3. Observed indicators for positive emotion
  \item y4-y6. Observed indicators for negative emotion
}
}
\keyword{datasets}

