% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_arg}
\alias{get_arg}
\title{Getting Argument From System, Option or Default}
\usage{
get_arg(opt = NULL, sys = NULL, default = NULL, split = ";")
}
\arguments{
\item{opt}{(\code{string}) the name of an option.}

\item{sys}{(\code{string}) the name of an environment variable.}

\item{default}{value to return if neither the environment variable nor the option are set.}

\item{split}{(\code{string}) the pattern used to split the values obtained using environment variable.}
}
\value{
if defined, the value of the option (\code{opt}), a \code{character} from the environment variable (\code{sys}) or the
\code{default} in this order of priority.
}
\description{
Getting Argument From System, Option or Default
}
\examples{
\dontshow{if (require("withr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_arg("my.option", "MY_ARG", "default")
withr::with_envvar(c(MY_ARG = "x;y"), get_arg("my.option", "MY_ARG", "default"))
withr::with_options(c(my.option = "y"), get_arg("my.option", "MY_ARG", "default"))
\dontshow{\}) # examplesIf}
}
