% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_dataset.R
\name{write_geo}
\alias{write_geo}
\title{Write a spatial file with gdal}
\usage{
write_geo(
  dataset,
  path,
  conn = cached_connection(),
  driver = "GeoJSON",
  layer_creation_options = "WRITE_BBOX=YES"
)
}
\arguments{
\item{dataset}{a remote tbl object from \code{open_dataset},
or an in-memory data.frame.}

\item{path}{a local file path or S3 path with write credentials}

\item{conn}{duckdbfs database connection}

\item{driver}{driver, see \url{https://duckdb.org/docs/stable/extensions/spatial/gdal}}

\item{layer_creation_options}{to GDAL, see \url{https://duckdb.org/docs/stable/extensions/spatial/gdal}}
}
\description{
Write a spatial file with gdal
}
\details{
NOTE: at this time, duckdb's pre-packaged GDAL does not support s3 writes,
and will produce a "Error: Not implemented Error: GDAL Error (6): Seek not supported on writable /vsis3/ files".
Use to_geojson() instead.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
local_file <-  system.file("extdata/spatial-test.csv", package="duckdbfs")
load_spatial()
tbl <- open_dataset(local_file, format='csv')
write_geo(tbl, "spatial.geojson")
\dontshow{\}) # examplesIf}
}
