% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_filter}
\alias{p_filter}
\title{Filtering data}
\usage{
p_filter(
  .data,
  ...,
  .messages = "excluded {.excluded} items",
  .headline = .defaultHeadline(),
  .type = "exclusion",
  .asOffshoot = (.type == "exclusion"),
  .stage = (if (is.null(.tag)) "" else .tag),
  .tag = NULL
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{.data}. If multiple expressions are included, they are combined with the
\code{&} operator. Only rows for which all conditions evaluate to \code{TRUE} are
kept.
  Named arguments passed on to \code{\link[dplyr:filter]{dplyr::filter}}\describe{
    \item{\code{.by}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}
\item{\code{.preserve}}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, or \{.strata\},\{.count.in\},and \{.count.out\}}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, or \{.strata\},\{.count.in\},and \{.count.out\}}

\item{.type}{the format type of the action typically an exclusion}

\item{.asOffshoot}{if the type is exclusion, \code{.asOffshoot} places the
information box outside of the main flow, as an exclusion.}

\item{.stage}{a name for this step in the pathway}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with \code{.tag}.}
}
\value{
the filtered \code{.data} dataframe with history graph updated
}
\description{
Filter acts in the same way as in \code{dplyr} where predicates which evaluate to
TRUE act to select items to include, and items for which the predicate cannot
be evaluated are excluded. For tracking prior to the filter operation the
size of each group is calculated \{.count.in\} and after the operation the
output size of each group \{.count.out\}. The grouping \{.strata\} is also
available (if grouped) for reporting. See \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\examples{
library(dplyr)
library(dtrackr)

tmp = iris \%>\% track() \%>\% dplyr::group_by(Species)
tmp \%>\% filter(Petal.Length > 5) \%>\% history()
}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
