% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{nest.trackr_df}
\alias{nest.trackr_df}
\title{Reshaping data using \code{tidyr::nest}}
\usage{
\method{nest}{trackr_df}(
  .data,
  ...,
  .by = NULL,
  .key = NULL,
  .names_sep = NULL,
  .messages = c("{.count.out} items"),
  .headline = ""
)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to nest; these will
appear in the inner data frames.

Specified using name-variable pairs of the form
\code{new_col = c(col1, col2, col3)}. The right hand side can be any valid
tidyselect expression.

If not supplied, then \code{...} is derived as all columns \emph{not} selected by
\code{.by}, and will use the column name from \code{.key}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
previously you could write \code{df \%>\% nest(x, y, z)}.
Convert to \code{df \%>\% nest(data = c(x, y, z))}.}

\item{.by}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to nest \emph{by}; these
will remain in the outer data frame.

\code{.by} can be used in place of or in conjunction with columns supplied
through \code{...}.

If not supplied, then \code{.by} is derived as all columns \emph{not} selected by
\code{...}.}

\item{.key}{The name of the resulting nested column. Only applicable when
\code{...} isn't specified, i.e. in the case of \code{df \%>\% nest(.by = x)}.

If \code{NULL}, then \code{"data"} will be used by default.}

\item{.names_sep}{If \code{NULL}, the default, the inner names will come from
the former outer names. If a string, the  new inner names will use the
outer names with \code{names_sep} automatically stripped. This makes
\code{names_sep} roughly symmetric between nesting and unnesting.}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, grouping variable, \{.count.in\}, \{.count.out\} or \{.strata\}.
Defaults to \code{"{.count.out} items"}.}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, grouping variable, or \{.strata\}. Defaults to nothing.}
}
\value{
the data dataframe result of the \code{tidyr::nest} function but with a
history graph updated.
}
\description{
A drop in replacement for \code{\link[tidyr:nest]{tidyr::nest()}} which optionally takes a message
and headline to store in the history graph.
}
\examples{
library(dplyr)
library(dtrackr)

starwars \%>\%
  track() \%>\%
  tidyr::unnest(starships, keep_empty = TRUE) \%>\%
  tidyr::nest(world_data = c(-homeworld)) \%>\%
  history()

# There is a problem with `tidyr::unnest` that means if you want to override the
# `.messages` option at the moment it will most likely fail. Forcing the use of
# the specific `dtrackr::p_unnest` version solves this problem, until hopefully it is
# resolved in `tidyr`:
starwars \%>\%
  track() \%>\%
  p_unnest(
    films,
    .messages = c("{.count.in} characters", "{.count.out} appearances")
  ) \%>\%
  dplyr::group_by(gender) \%>\%
  tidyr::nest(
    people = c(-gender, -species, -homeworld),
    .messages = c("{.count.in} appearances", "{.count.out} planets")
  ) \%>\%
  status() \%>\%
  history()

# This example includes pivoting and nesting. The CMS patient care data
# has multiple tests per institution in a long format, and observed /
# denominator types. Firstly we pivot the data to allow us to easily calculate
# a total percentage for each institution. This is duplicated for every test
# so we nest the tests to get to one row per institution. Those institutions
# with invalid scores are excluded.
cms_history = tidyr::cms_patient_care \%>\%
  track() \%>\%
  tidyr::pivot_wider(names_from = type, values_from = score) \%>\%
  dplyr::mutate(
    percentage = sum(observed) / sum(denominator) * 100,
    .by = c(ccn, facility_name)
  ) \%>\%
  tidyr::nest(
    results = c(measure_abbr, observed, denominator),
    .messages = c("{.count.in} test results", "{.count.out} facilities")
  ) \%>\%
  exclude_all(
    percentage > 100 ~ "{.excluded} facilities with anomalous percentages",
    na.rm = TRUE
  )

print(cms_history \%>\% dtrackr::history())

# not run in examples:
if (interactive()) {
  cms_history \%>\% flowchart()
}
}
\seealso{
\code{\link[tidyr:nest]{tidyr::nest()}}
}
