% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_vector.R
\name{rename_vector}
\alias{rename_vector}
\title{Rename character vector}
\usage{
rename_vector(
  input,
  lexin = c("phase2", "phase1", "short1", "short2", "gsed", "gsed2", "gsed3"),
  lexout = c("gsed3", "gsed2", "gsed", "short2", "short1", "phase1", "phase2"),
  notfound = "copy",
  contains = c("", "Ma_SF_", "Ma_LF_", "bsid_"),
  underscore = TRUE,
  trim = "Ma_",
  lowercase = TRUE,
  force_subjid_agedays = FALSE
)
}
\arguments{
\item{input}{A character vector with names to be translated}

\item{lexin}{A string indicating the input lexicon. One of \code{"phase1"},
\code{"phase2"}, \code{"short1"}, \code{"short2"}, \code{"gsed"}, \code{"gsed2"} or \code{"gsed3"}.
Default is \code{"phase2"}, which orders item names according to the
published 2023 version of the SF and LF instruments.}

\item{lexout}{A string indicating the output lexicon. One of \code{"phase1"},
\code{"phase2"}, \code{"short1"}, \code{"short2"}, \code{"gsed"}, \code{"gsed2"}, \code{"gsed3"}.
Default is \code{"gsed3"}. The default output \code{"gsed3"} applies instrument
codes \code{gs1} (SF) and \code{gl1} (LF), which can be understood by the \code{dscore}
package.}

\item{notfound}{A string indicating what to do some input value is not found}

\item{contains}{A string to filter the translation table prior to matching.
Needed to prevent double matches. The default ("") does not filter.}

\item{underscore}{Replaces space (" ") and dash ("-") by underscore ("_")}

\item{trim}{A substring to be removed from \code{input}. Defaults to "Ma_".}

\item{lowercase}{Sets all variables in lower case.
in \code{lexin}? The default \code{notfound = "copy"} copies the input values into the
output value. In other cases (e.g. \code{""} or \code{NA_character_}), the function
uses the string specified in \code{notfound} as a replacement value.}

\item{force_subjid_agedays}{If \code{TRUE}, forces the output to have \code{"subjid"}
and \code{"agedays"} as names for the \code{"ID"} and \code{"age"}, respectively.}
}
\value{
A character vector of the same length as \code{input} with processed
names.
}
\description{
Translates names between different lexicons (naming schema).
}
\details{
The recommended approach for reading new data is to name the columns
according to the names defined by \code{"short2"} and the apply \code{rename_vector()}
to translate the names to the \code{"gsed3"} lexicon.

The lexicons \code{"phase1"}, \code{"short1"}, \code{"gsed"} and \code{"gsed2"} are included
for backward compatibility, and are not recommended for use with new
data.
}
\examples{
# Using Ma_SF_Cxx as input names, 2023 SF/LF version
input <- c("file", "GSED_ID", "Ma_SF_Parent ID", "Ma_SF_C01", "Ma_SF_C02")
rename_vector(input)
rename_vector(input, lexout = "short2", lowercase = FALSE)
rename_vector(input, lexout = "gsed3", trim = "Ma_SF_")

# Convert short names to gsed names
input <- c("file", "GSED_ID", "Ma_SF_Parent ID", paste0("SF00", 1:3))
rename_vector(input, lexin = "short2", lowercase = TRUE)
}
