% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{i2ds_survey}
\alias{i2ds_survey}
\title{Data from the i2ds online survey}
\format{
On 2025-09-11, this data contains 36 participants (rows) and 112 variables (columns).
}
\source{
See online survey at \url{https://ww3.unipark.de/uc/i2ds_survey/}.
}
\usage{
i2ds_survey
}
\description{
\code{i2ds_survey} contains pre-processed data 
from the i2ds online survey.
}
\details{
\strong{Prefix codes}

Many variable names have prefixes that denote a particular type of variable:

\itemize{

\item \strong{rv}: A random variable

\item \strong{c(#)}: A choice variable (with # alternatives)

\item \strong{t}: A text variable (with any input)

\item \strong{tn}: A text variable (with numeric input)

\item \strong{crs}: A course-related variable

\item \strong{combined}: A composite variable created by averaging either 4 or 5 individual Likert-scale items.
Depending on the item set, the resulting score was normalized (i.e., divided by 4 or 5), and stored as a new variable.

}


\strong{List of variables}

After pre-processing the raw data, the variable names and their contents in the \code{i2ds_survey} tibble are as follows:

\itemize{

\item 1. \code{rv_anchor_high_low} A randomized (character) variable that indicates whether a person is to keep a relatively large or small number in memory (i.e., assignment to either \code{242} or \code{42}, respectively). This manipulation is used to examine anchoring effects on later responses.

\item 2. \code{rv_scale_randomization} A randomized (character) variable that indicates whether a person was asked to rate their personality (from "serious" to "humorous") on a 4-point or on a 5-point Likert scale. 
The variable controls for the influence of scale granularity on ratings. 

\item 3. \code{rv_barnum_pos_neg} A randomized (character) variable that indicates whether the participant is to receive a positive or negative Barnum statement ("positive" vs. "negative"). This is used to measure sensitivity to vague or generic personality feedback.

\item 4. \code{rv_sc_false_dicho_3} A randomized (character) variable indicating which version of the scale is to be shown: a dichotomous comparison between admiration vs. respect, fear vs. love, admiration vs. love and fear, or a single undivided scale (values: "admir_resp"  "fear_love", "admir_love" fear_resp", "single_scale"). Used to examine how scale format affects evaluative judgments.

\item 5. \code{rv_wait_time} A randomized (character) variable that indicates whether the participant waited 10 seconds ("short") or 30 seconds ("long") before continuing. This manipulation aims to examine whether a longer waiting period increases the perceived credibility or value of a following personality feedback, in line with mechanisms underlying the Barnum effect.

\item 6. \code{rv_political_orientation} A randomized (character) variable indicating the order in which the two political orientation scales ("left–right" and "liberal–conservative") were presented. Possible values include "left_right, lib_cons", "left_cons, lib_right", etc. This variable is used to control for potential order effects in political self-placement tasks.

\item 7. \code{rv_thinkingstyle} A randomized (character) variable that indicates the order in which pairs of thinking styles are to be presented ("deliberative vs. intuitive"; "reflective vs. spontaneous";" deliberative vs. spontaneous";"reflective vs. Intuitive"). The order is counterbalanced to reduce presentation bias in self-assessment tasks.


\item 8. \code{c2_informed_consent} A logical variable indicating whether the participant provided informed consent before starting the study 
(\code{TRUE} = consent provided, \code{FALSE} = no consent provided). 
This variable is a pre-requisite for ethical compliance (i.e., should be \code{TRUE} for all participants).


\item 9. \code{c2_img_sel_1} A numeric (double) variable that represents the participant's preferred choice between 2 images in choice Set 1. 
The binary variable indicates the participant's image preference: 
\itemize{
\item \code{1} corresponds to the \emph{cubist} painting \emph{Les Baigneurs (the bathers), Roger de La Fresnaye, 1912} 
\item \code{2} corresponds to the \emph{expressionist} painting \emph{Badende Mädchen (bathing girls), August Macke, 1913}
}

\item 10. \code{c2_img_sel_2} A numeric (double) variable that represents the participant's preferred choice between 2 images in choice Set 2. 
The binary variable indicates the participant's image preference: 
\itemize{
\item \code{1} corresponds to the \emph{cubist} painting \emph{Le Gouter (the taster, aka. tea time), Jean Metzinger, 1911} 
\item \code{2} corresponds to the \emph{expressionist} painting \emph{La petite Jeanne, Amedeo Modigliani, 1909}
}

\item 11. A numeric (double) variable that represents the participant's preferred choice between 2 images in choice Set 3. 
The binary variable indicates the participant's image preference: 
\itemize{
\item \code{1} corresponds to the \emph{cubist} painting \emph{Edtaonisl Ecclesiastic (the 1st word being an acronym made by alternating the French words for 'star' and 'dance'), Francis Picabia, 1913} 
\item \code{2} corresponds to the \emph{impressionist} painting \emph{Femme avec parasol dans un jardin (woman with parasol in a garden), Pierre-Auguste Renoir, 1875}
}

\item 12. A numeric (double) variable that represents the participant's preferred choice between 2 images in choice Set 4. 
The binary variable indicates the participant's image preference: 
\itemize{
\item \code{1} corresponds to the \emph{expressionist} painting \emph{Solitude, Alexej von Jawlensky, 1912} 
\item \code{2} corresponds to the \emph{impressionist} painting \emph{Pont dans le Jardin de Monet (bridge in Monet’s garden), Claude Monet, 1895–96}
}


\item 13. \code{c7_eating_habits} A categorical (character) variable that indicates which dietary lifestyle an individual assigns to itself
(\code{1} = "vegetarian"; \code{2} = "omnivore"; \code{3} = "vegan"; \code{4} = "pescetarian"; \code{5} = "flexitarian"; \code{6} = "carnivore"; \code{7} = "other"). 

\item 14. \code{t_eating_habits_other} A character variable intended to capture free-text input for other dietary descriptions; 
usually \code{NA} unless "other" was selected. May appear as logical if no responses were entered.

\item 15. \code{c7_apple} A numeric (double) variable indicating how much a participant likes apples 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\item 16. \code{c7_cherry} A numeric (double) variable indicating how much a participant likes cherries 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\item 17. \code{c7_broccoli} A numeric (double) variable indicating how much a participant likes broccoli 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\item 18. \code{c7_asparagus} A numeric (double) variable indicating how much a participant likes asparagus 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\item 19. \code{c7_spinach} A numeric (double) variable indicating how much a participant likes spinach 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\item 20. \code{c7_mud} A numeric (double) variable indicating how much a participant likes mud 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\item 21. \code{c7_banana} A numeric (double) variable indicating how much a participant likes bananas 
on a \code{1-7} scale (\code{1} = low preference, \code{7} = high preference).

\strong{Note}: Variables \code{c7_apple} to \code{c7_banana} were derived from a sorting/ranking task in which each participant sorted/ranked food items by preference. 
Each item was subsequently coded as a numeric value between \code{1} and \code{7}.


\item 22. \code{c2_decsleep_instant} A categorical (character) variable indicating whether a participant prefers to sleep 
before making important decisions ("sleep") or to make them instantly ("instant"). 

\item 23. \code{c2_shopperson_online} A categorical (character) variable indicating whether a participant prefers shopping in person ("person") or online ("online").

\item 24. \code{c2_town_city} A categorical (character) variable indicating whether a participant prefers living in a town ("town") or in a city ("city"). 

\item 25. \code{c2_club_house} A categorical (character) variable indicating whether a participant prefers to party in a club ("club") or to attend an house party ("house").

\item 26. \code{c2_hotel_camping} A categorical (character) variable capturing a participant's preference for staying in a hotel ("hotel") versus going camping ("camping"). 

\item 27. \code{c2_photo_being} A categorical (character) variable indicating whether a participant prefers photographing ("photo") or being in a moment ("being"). 

\item 28. \code{c2_spring_fall} A categorical (character) variable indicating whether a participant prefers the spring season ("spring") or the fall/autumn season ("fall").

\item 29. \code{c2_beach_mount} A categorical (character) variable reflecting whether a participant prefers the beach ("beach") or the mountains ("mount"). 

\item 30. \code{c2_cats_dogs} A categorical (character) variable indicating preference for cats ("cats") versus dogs ("dogs").

\item 31. \code{c2_indiv_team} A categorical (character) variable indicating whether a participant prefers individual ("indiv") or team sports ("team").

\item 32. \code{c2_movies_books} A categorical (character) variable indicating a participant's preference for movies ("movies") or books ("books").

\item 33. \code{c2_board_video} A categorical (character) variable indicating whether a participant prefers board games ("board") or video games ("video").

\item 34. \code{c2_ios_android} A categorical (character) variable indicating whether a participant prefers iOS ("ios") or Android ("android") as a mobile operating system.

\item 35. \code{c2_text_voice} A categorical (character) variable indicating whether a participant prefers texting ("text") or sending voice messages ("voice").

\item 36. \code{c2_cook_bake} A categorical (character) variable indicating whether a participant prefers cooking ("cook") or baking ("bake").

\item 37. \code{c2_pinapple_no} A categorical (character) variable that records whether a participant likes pineapple on pizza ("yes") or not ("no").

\item 38. \code{c2_ketchup_mayo} A categorical (character) variable indicating whether a participant prefers ketchup ("ketchup") or mayonnaise ("mayo").

\item 39. \code{c2_coffee_tea} A categorical (character) variable indicating whether a participant prefers coffee ("coffee") or tea ("tea").

\item 40. \code{c2_math_lang} A categorical (character) variable indicating whether a participant prefers mathematics ("math") or language-related subjects ("lang"). 

\item 41. \code{c2_odd_even} A categorical (character) variable indicating whether a participant prefers odd numbers ("odd") or even numbers ("even"). 


\item 42. \code{c3_diff_bin} A categorical (character) variable indicating how difficult it was for a participant to make their previous preference decisions (items 22--41) . 
Response options include "yes", "a little", and "no". 
This item captures perceived decisional difficulty and may serve as an indicator of response certainty, thinking style, or task engagement.


\item 43. \code{politics_left} A numeric (double) variable representing the participant’s self-placement on a left–right political spectrum. 
Values range from \code{1} (left) to \code{6} (right).

\item 44. \code{politics_liberal} A numeric (double) variable representing self-placement on a liberal to conservative scale, ranging from \code{1} (liberal) to \code{6} (conservative). 


\item 45. \code{tn_estimate_sun} A numeric (double) variable capturing the participant’s estimate of how many times larger the sun’s diameter is compared to that of the earth. 
This item serves as a manipulation check for the anchoring effect, based on previously presented numeric anchors (e.g., \code{42} or \code{242}). 

\item 46. \code{t_att_check_1}  A character variable containing the participant’s open-text response to an attention check prompt ("Please type: 'I read the instructions'"). 
This attention check allows detecting inattentive or automated responses.

\item 47. \code{c2_fly_invisible} A categorical (character) variable indicating whether the participant would prefer the superpower of flying ("fly") or becoming invisible ("invisible"). 

\item 48. \code{t_fly_invisible_explain} A character variable where participants explain their choice between flying and invisibility. 
This free text answer allows for qualitative analysis of a participant's justifications and motivations.


\item 49. \code{combined_c_ser_hum_self} A numeric (double) variable reflecting a participant’s self-assessment on a "serious vs. humorous" scale. 
The score is based on a 4-point or 5-point Likert scale, depending on random assignment. 
This variable is used to test how perspective (self vs. others) and scale format (presence vs. absence of a middle option) influences self-ratings.

\item 50. \code{combined_c_ser_hum_others} A combined numeric (double) variable reflecting how humorous or serious participants believe others to perceive them. 
This score is derived from either a 4-point or 5-point scale and is used to examine the effect of perspective and scale design on perceived external ratings. 


\item 51. \code{c4_chronotype}  A categorical (character) variable indicating whether the participant identifies as a 
morning person ("morning"), evening person ("evening") mid-day person ("mid-day") or a never person ("never"). 

\item 52. \code{tn_sleep} A numeric (double) variable indicating the typical number of hours the participant typically sleeps per night. 

\item 53. \code{tn_bedtime} A character variable representing the participant’s usual bedtime, 
to be entered in 24-hour format (e.g., "22:30", "00:00").

\item 54. \code{tn_anchor_recall_1} A numeric (double) variable recording the number (either \code{42} or \code{242}) that the participant was previously asked to memorize and later recall. 
It is used to test memory for the anchor manipulation.


\item 55. \code{combined_admired} A combined numeric (double) variable reflecting how much a participant wants to be admired by others, 
rated on a \code{1–6} Likert scale (\code{1} = not at all, \code{6} = very much).

\item 56. \code{combined_feared} A combined numeric (double) variable reflecting how much a participant wants to be feared by others, 
#' rated on a \code{1–6} Likert scale (\code{1} = not at all, \code{6} = very much).

\item 57. \code{combined_loved} A combined numeric (double) variable reflecting how much a participant wants to be loved by others, 
#' rated on a \code{1–6} Likert scale (\code{1} = not at all, \code{6} = very much).

\item 58. \code{combined_respected}  A combined numeric (double) variable reflecting how much a participant wants to be respected by others, 
#' rated on a \code{1–6} Likert scale (\code{1} = not at all, \code{6} = very much).


\item 59. \code{c7_pess_opti} A numeric (double) variable capturing a participant’s self-rated tendency toward pessimism versus optimism, 
on a 7-point scale (\code{1} = very pessimistic, \code{7} = very optimistic). 

\item 60. \code{c7_story_list} A numeric (double) variable indicating how much a participant enjoys listening to or reading stories, 
rated from \code{1} (not at all) to \code{7} (very much). 

\item 61. \code{c7_stab_adv} A numeric (double) variable indicating a participant’s self-assessed position on a stability versus adventurousness spectrum, 
rated on a scale from \code{1} (very stable) to \code{7} (very adventurous). 
This variable may indicate personality traits related to risk-taking.


\item 62. \code{think_reflect} A numeric (double) variable representing a participant’s placement on a bipolar scale ranging from \code{1} ("reflective") to \code{6} (either "spontaneous" or " intuitive"). 
The specific version of the 2nd scale anchor is randomly assigned. 

\item 63. \code{think_delib} A numeric (double) variable representing a participant’s placement on a bipolar scale ranging from \code{1} ("deliberative") to \code{6} (either "intuitive" or " spontaneous". 
The specific version of the 2nd scale anchor is randomly assigned. 


\item 64. \code{c4_intro_extrovert} A categorical (character) variable indicating a participant's self-rated social orientation: 
"introverted", "extroverted", or mixed variants such as "extro-intro" or "intro-extro". 

\item 65. \code{tn_favorit_number} A numeric (double) variable capturing a participant’s favorite number, 
in free answer format. 


\item 66. \code{c3_cutlery} A categorical (character) variable indicating which piece of cutlery a participant most identifies with. 
The 3 possible values include "knife", "fork", and "spoon". 

\item 67. \code{c3_rock_paper_scissors} A categorical (character) variable capturing a participant's selection in a rock–paper–scissors scenario. 
The 3 possible values are "rock", "paper", or "scissors".


\item 68. \code{c5_att_check_2} A numeric (double) variable used as an attention check. 
Participants were asked to select the number that most resembles the shape of a circle. 
The correct response is \code{0}, which corresponds to scale option 5. 
Responses deviating from this may indicate inattentiveness.


\item 69. \code{c6_barnum_accuracy} A numeric (double) variable indicating how accurately a participant rated a generic personality description (i.e., a Barnum statement), 
on a scale from \code{1} (poor) to \code{6} (perfect). 
This variable is used to assess susceptibility to the so-called \emph{Barnum effect} (i.e., the tendency to perceive vague and general statements as highly accurate). 


\item 70. \code{t_anchor_recall_2} A numeric (double) variable recording whether a participant correctly remembered a previously presented number (either \code{42} or \code{242}). 
This assesses memory and anchoring manipulation success (for a 2nd time).


\item 71. \code{c4_gender} A categorical (character) variable indicating the participant’s gender identity, 
with possible values including "female", "male", "non-binary" or "do not wish to respond". This variable is used for demographic analysis.


\item 72. \code{tn_day} A numeric (double)variable indicating the day of birth provided by the participant (\code{1–31}). 
Used for demographic purposes and potential exploratory analyses. 

\item 73. \code{tn_month} A numeric (double) variable indicating the participant’s birth month (\code{1–12}). 
This variable also supports demographic profiling. 

\item 74. \code{tn_year} A numeric (double) variable indicating the year of birth (e.g., \code{1999, 2000, 2001}, etc.). 
Variables 72. to 74. can be used to calculate age and analyze age-related trends. 


\item 75. \code{t_height} A character variable indicating a participant's self-described height, using various formats and units 
(e.g., "1.80", "180 cm", "1,80m", or "5'11"). This variable requires pre-processing for analysis.


\item 76. \code{c9_occupation} A categorical (character) variable indicating a participant’s current occupational status 
(e.g., "student", "employed", "other"). This variable may be used for demographic segmentation. 

\item 77. \code{t_occupation_other} A logical variable for free-text input if a participant selected "other" for occupation. 
This variable captures detailed occupational descriptions not covered by the pre-defined options.

\item 78. \code{c7_education} A categorical (character) variable indicating a participant’s highest completed education level 
(e.g., "high school", "bachelor", "master"). This variable may be used for demographic segmentation.

\item 79. \code{t_education_other} A logical variable to allow participants to enter their education level in free text (if "other" was selected). 
This variable enables open-format responses for less common education paths.

\item 80. \code{c3_current_degree} A categorical (character) variable indicating the type of academic degree a participant is currently pursuing (e.g, "bachelor", "master"). 
This variable provides educational context for other academic measures.

\item 81. \code{tn_semester} A numeric (double) variable indicating the current semester of study reported by a participant (e.g., 1, 6, 10). 
This variable helps contextualize course experience and academic progress.

\item 82. \code{c14_studyfield} A categorical (character) variable indicating the participant’s field of study (e.g., "psychology", "data science"). 
This variable is used to examine field-specific attitudes and skills.

\item 83. \code{t_studyfield_other} A character variable capturing free-text responses if the participant selected "other" as their study field. 
This variable allows classification of less common disciplines. 


\item 84. \code{crs_i2ds_1} A logical variable indicating whether a participant is currently enrolled in the course \emph{Introduction to Data Science 1: Basics} (i2ds 1: \code{TRUE} = enrolled). 

\item 85. \code{crs_i2ds_2} A logical variable indicating whether a participant is enrolled in the course \emph{Introduction to Data Science 2: Applications} (i2ds 2: \code{TRUE} = enrolled). 

\item 86. \code{crs_ds4psy} A logical variable indicating whether a participant is enrolled in the course \emph{Data Science for Psychology} (ds4psy: \code{TRUE} = enrolled).

\item 87. \code{crs_diff_kn} A logical variable indicating whether a participant is enrolled in a different course at the \emph{University of Konstanz} (\code{TRUE} = yes). 

\item 88. \code{crs_diff_else} A logical variable indicating whether a participant is enrolled in a course \emph{not} at the \emph{University of Konstanz} (\code{TRUE} = yes). 
This variable helps identifying external learners.

\item 89. \code{crs_self_study} A logical variable indicating whether a participant is engaging with course materials without formal enrollment (\code{TRUE} = yes). 
This variable reflects informal learning engagement.

\item 90. \code{crs_only_study} A logical variable indicating whether a participant is taking the survey only, without engaging with course materials (\code{TRUE} = yes). 
This variable identifies non-learning participants.

\item 91. \code{t_crs_other} A character variable capturing free-text input describing any other course a participant is taking. 

\item 92. \code{v_crs_other_dept} A character variable indicating the department of the other course(s) mentioned in \code{t_crs_other}. 
This variable may facilitate grouping participants by academic discipline.


\item 93. \code{c5_pref_stats} A numeric (double) variable indicating a participant’s interest in preparing data for statistical analysis, 
rated on a scale from \code{1} (no interest) to \code{5} (absolutely essential).

\item 94. \code{c5_pref_visualize} A numeric (double) variable indicating a participant's interest in data visualization in R, 
rated on a scale from \code{1} (no interest) to \code{5} (absolutely essential).

\item 95. \code{c5_pref_sims} A numeric (double) variable indicating a participant’s interest in using R for simulations and modeling, 
rated on a scale from \code{1} (no interest) to \code{5} (absolutely essential).

\item 96. \code{c5_pref_shiny} A numeric (double) variable capturing how essential a participant considers learning to build interactive web applications using R Shiny. 
Responses range from \code{1} (no interest) to \code{5} (absolutely essential).

\item 97. \code{c5_pref_scrape} A numeric (double) variable capturing how essential a participant considers learning web scraping with R. 
Responses range from \code{1} (no interest) to \code{5} (absolutely essential).

\item 98. \code{c5_pref_arts} A numeric (double) variable capturing how essential a participant considers exploring artistic or creative aspects of data science (e.g., generative art in R). 
Responses range from \code{1} (no interest) to \code{5} (absolutely essential).


\item 99. \code{t_crs_expect_i2ds_1} A character variable containing free-text input describing a participant’s expectations and hopes for the course \emph{Introduction to Data Science 1: Basics} (i2ds 1). 

\item 100. \code{t_crs_worry_i2ds_1} A character variable capturing free-text responses describing a participant’s worries and reservations related to the course \emph{Introduction to Data Science 1: Basics} (i2ds 1). 

\item 101. \code{t_crs_expect_i2ds_2} A character variable containing free-text input describing a participant’s expectations and hopes for the course \emph{Introduction to Data Science 2: Applications} (i2ds 2). 

\item 102. \code{t_crs_worry_i2ds_2} A character variable capturing free-text input describing a participant’s worries and reservations concerns related to the course \emph{Introduction to Data Science 2: Applications} (i2ds 2). 

\item 103. \code{t_crs_expect_ds4psy} A logical variable containing free-text input describing a participant’s expectations and hopes for the course \emph{Data Science for Psychology} (ds4psy). 

\item 104. \code{t_crs_worry_ds4psy} A logical variable describing a participant’s worries and reservations regarding the course \emph{Data Science for Psychology} (ds4psy), in free text format. 


\item 105. \code{c6_exp_math} A numeric (double) variable indicating a participant’s self-assessed experience with mathematics, 
rated on a scale from \code{1} (no experience) to \code{6} (extremely experienced). 

\item 106. \code{c6_exp_statistics} A numeric (double) variable measuring a participant’s self-assessed experience with statistics, 
rated on a scale from \code{1} (no experience) to \code{6} (extremely experienced). 

\item 107. \code{c6_exp_program} A numeric (double) variable indicating a participant’s experience with programming (any programming language), 
rated on a scale from \code{1} (no experience) to \code{6} (extremely experienced).

\item 108. \code{c6_exp_r} A numeric (double) variable indicating a participant’s experience with R programming, 
rated on a scale from \code{1} (no experience) to \code{6} (extremely experienced).

\item 109. \code{c6_exp_datavisual} A numeric (double) variable capturing a participant’s prior experience with data visualization, 
rated on a scale from \code{1} (no experience) to \code{6} (extremely experienced).


\item 110. \code{c2_use_data_2} A logical variable indicating whether a participant still agrees to allow their data to be shared after having finished the survey 
(\code{TRUE} = consent provided, \code{FALSE} = no consent provided). 
This variable is a pre-requisite for data re-usability in research (and should be \code{TRUE} for all cases included here). 


\item 111. \code{t_pid} An optional character variable capturing a participant ID, pseudonym, or other identifying entry. 
This variable allows participants to recognize their own data without disclosing their identity.


\item 112. \code{t_feedback} An optional character variable containing general feedback provided by the participant regarding the survey or course. 
This is an open-ended text field for final comments, impressions, or suggestions.

}

See the \strong{codebook} and \strong{print version} for additional coding details.

\strong{Missing values} in the dataset are represented as \code{NA} values. 
These indicate that a participant did not provide a response or that the question was not applicable.
}
\seealso{
Other datasets: 
\code{\link{Bushisms}},
\code{\link{Trumpisms}},
\code{\link{countries}},
\code{\link{data_1}},
\code{\link{data_2}},
\code{\link{data_t1}},
\code{\link{data_t1_de}},
\code{\link{data_t1_tab}},
\code{\link{data_t2}},
\code{\link{data_t3}},
\code{\link{data_t4}},
\code{\link{dt_10}},
\code{\link{exp_num_dt}},
\code{\link{exp_wide}},
\code{\link{falsePosPsy_all}},
\code{\link{fame}},
\code{\link{flowery}},
\code{\link{fruits}},
\code{\link{outliers}},
\code{\link{pi_100k}},
\code{\link{posPsy_AHI_CESD}},
\code{\link{posPsy_long}},
\code{\link{posPsy_p_info}},
\code{\link{posPsy_wide}},
\code{\link{t3}},
\code{\link{t4}},
\code{\link{t_1}},
\code{\link{t_2}},
\code{\link{t_3}},
\code{\link{t_4}},
\code{\link{table6}},
\code{\link{table7}},
\code{\link{table8}},
\code{\link{table9}},
\code{\link{tb}}
}
\concept{datasets}
\keyword{datasets}
