% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opti_helpers.R
\name{max_ratio_new}
\alias{max_ratio_new}
\title{Find the max ratio of probabilities between two permutations.}
\usage{
max_ratio_new(z, gamma)
}
\arguments{
\item{z}{vector of doses}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}
}
\value{
the maximum ratio between the probability of two different permutations
under the Rosenbaum model with doses z and unmeasured confounding level gamma.
}
\description{
Find the max ratio of probabilities between two permutations.
}
\examples{
# A vector of observed doses
doses <- c(0, 0.1, 0.4, 0.8)
ratio <- max_ratio_new(z = doses, gamma = 1)
}
