% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_ci.R
\name{inv_tanh_ci}
\alias{inv_tanh_ci}
\title{Calculate confidence interval of DOOR probability based on inverse hyperbolic tangent transformation of Wald-type CI}
\usage{
inv_tanh_ci(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  data_type = c("freq", "prop"),
  summary_obj = NULL,
  conf_level = 0.95
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{summary_obj}{A object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{conf_level}{Confidence level}
}
\value{
Inverse hyperbolic tangent transformation CI
}
\description{
Calculate confidence interval of DOOR probability based on inverse hyperbolic tangent transformation of Wald-type CI
}
\examples{
inv_tanh_ci(c(60,30,10), c(50,40,10))
}
\seealso{
\code{\link[=door_ci]{door_ci()}}
}
