% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_gt.R
\name{scale_gt}
\alias{scale_gt}
\title{Scale gt table contents for document}
\usage{
scale_gt(x, tbl_stub_pct = 0.3)
}
\arguments{
\item{x}{table of class \code{gt_tbl}}

\item{tbl_stub_pct}{percent of total width that should be dedicated to stub column(s). If more than 1 stub column then this is the total for both.}
}
\value{
Table with col_widths settings applied
}
\description{
Scale gt table contents for document
}
\examples{

gt::gtcars |>
  dplyr::slice_head(n = 10) |>
  dplyr::select(mfr, model, year, msrp, ctry_origin) |>
  gt::gt(
      groupname_col = "ctry_origin",
      rowname_col = "mfr",
      row_group_as_column = TRUE) |>
  scale_gt(tbl_stub_pct = 0.4)

}
