% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{summary.univar_category}
\alias{summary.univar_category}
\alias{print.univar_category}
\title{Summarizing univar_category information}
\usage{
\method{summary}{univar_category}(object, na.rm = TRUE, ...)

\method{print}{univar_category}(x, ...)
}
\arguments{
\item{object}{an object of class "univar_category", usually, a result of a call to univar_category().}

\item{na.rm}{logical. Specifies whether to include NA when performing a chi-square test. 
The default is TRUE, where NA is removed and aggregated.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "univar_category", usually, a result of a call to univar_category().}
}
\value{
An object of the class as individual variables based list.
The information to examine the relationship between categorical variables is as follows each components.

\itemize{
\item variable : factor. The level of the variable. 'variable' is the name of the variable.
\item statistic : numeric. the value the chi-squared test statistic.
\item p.value : numeric. the p-value for the test.
\item df : integer. the degrees of freedom of the chi-squared test.
}
}
\description{
print and summary method for "univar_category" class.
}
\details{
print.univar_category() displays only the information of variables included in univar_category. 
The "variables" attribute is not displayed.
}
\examples{
\donttest{
library(dplyr)

# Calculates the all categorical variables
all_var <- univar_category(heartfailure)

# Print univar_category class object
all_var

# Calculates the only smoking variable
all_var \%>\% 
  "["(names(all_var) \%in\% "smoking")

smoking <- univar_category(heartfailure, smoking)

# Print univar_category class object
smoking

# Filtering the case of smoking included NA 
smoking \%>\%
  "[["(1) \%>\% 
  filter(!is.na(smoking))

# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Summary by returned object
stat
}

}
\seealso{
\code{\link{plot.univar_category}}.
}
