% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{eda_web_report}
\alias{eda_web_report}
\alias{eda_web_report.data.frame}
\title{Reporting the information of EDA with html}
\usage{
eda_web_report(.data, ...)

\method{eda_web_report}{data.frame}(
  .data,
  target = NULL,
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "EDA",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  title_color = "gray",
  logo_img = NULL,
  create_date = Sys.time(),
  theme = c("orange", "blue"),
  sample_percent = 100,
  is_tbl_dbi = FALSE,
  base_family = NULL,
  ...
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link[tibble]{tbl_df}}.}

\item{...}{arguments to be passed to methods.}

\item{target}{character. target variable.}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "EDA".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{title_color}{character. color of title. default is "gray".}

\item{logo_img}{character. name of logo image file on top left.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing EDA. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{is_tbl_dbi}{logical. whether .data is a tbl_dbi object.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\value{
No return value. This function only generates a report.
}
\description{
The eda_web_report() report the information of exploratory 
data analysis for object inheriting from data.frame.
}
\details{
Generate generalized EDA report automatically.
This feature is useful for EDA of data with many variables, rather than data with fewer variables.
}
\section{Reported information}{

Reported from the EDA is as follows.

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \item Data Types
    \item Job Information
  }
  \item Univariate Analysis
  \itemize{
    \item Descriptive Statistics
    \item Normality Test
  }   
  \item Bivariate Analysis
  \itemize{
    \item Compare Numerical Variables
    \item Compare Categorical Variables
  }
  \item Multivariate Analysis
  \itemize{
    \item Correlation Analysis
    \itemize{
      \item Correlation Matrix
      \item Correlation Plot
    }
  }
  \item Target based Analysis
  \itemize{
    \item Grouped Numerical Variables
    \item Grouped Categorical Variables
    \item Grouped Correlation
  }
}

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}

\examples{
\donttest{
if (FALSE) {
# create the dataset
heartfailure2 <- dlookr::heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "sodium"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

# create html file. file name is EDA_Report.html
eda_web_report(heartfailure2)

# file name is EDA.html. and change logo image
logo <- file.path(system.file(package = "dlookr"), "report", "R_logo_html.svg")
eda_web_report(heartfailure2, logo_img = logo, title_color = "black",
  output_file = "EDA.html")

# file name is ./EDA_heartfailure.html, "blue" theme and not browse
eda_web_report(heartfailure2, target = "death_event", output_dir = ".", 
  author = "Choonghyun Ryu", output_file = "EDA_heartfailure.html", 
  theme = "blue", browse = FALSE)
}
}

}
\seealso{
\code{\link{eda_web_report.tbl_dbi}}.
}
