% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_hurlbert.R
\name{div_hurlbert}
\alias{div_hurlbert}
\alias{div_hurlbert.numeric}
\alias{div_hurlbert.species_distribution}
\title{Hurlbert Diversity of a Community}
\usage{
div_hurlbert(x, k = 1, ...)

\method{div_hurlbert}{numeric}(
  x,
  k = 2,
  estimator = c("Hurlbert", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{div_hurlbert}{species_distribution}(
  x,
  k = 2,
  estimator = c("Hurlbert", "naive"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances}  or \link{probabilities}.}

\item{k}{the order of Hurlbert's diversity.}

\item{...}{Unused.}

\item{estimator}{An estimator of asymptotic diversity.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with the site names, the estimators used and the estimated diversity.
}
\description{
Estimate the diversity sensu stricto, i.e. the effective
number of species \insertCite{Dauby2012;textual}{divent}
from abundance or probability data.
}
\details{
Several estimators are available to deal with incomplete sampling.

Bias correction requires the number of individuals.

Estimation techniques are from \insertCite{Hurlbert1971;textual}{divent}.

Hurlbert's diversity cannot be estimated at a specified level of interpolation or
extrapolation, and diversity partioning is not available.
}
\examples{
# Diversity of each community
div_hurlbert(paracou_6_abd, k = 2)

}
\references{
\insertAllCited{}
}
\seealso{
\link{ent_hurlbert}
}
