% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{unfold_idx}
\alias{unfold_idx}
\alias{fold_idx}
\title{Fold and Unfold a dfidx object}
\usage{
unfold_idx(x)

fold_idx(x, pkg = NULL, sort = FALSE)
}
\arguments{
\item{x}{a \code{dfidx} object}

\item{pkg}{if not \code{NULL}, this argument is passed to \code{dfidx}}

\item{sort}{a boolean, whether the resulting \code{dfidx} object should
be sorted or not}
}
\value{
a data frame for the \code{unfold_dfidx} function, a \code{dfidx}
object for the \code{fold_dfidx} function
}
\description{
\code{fold_idx} takes a \code{dfidx} object, includes the indexes as stand
alone columns, remove the \code{idx} column and return a data frame,
with an \code{ids} attribute that contains the informations about the
indexes. \code{fold_idx} performs the opposite operation.
}
\examples{
mn <- dfidx(munnell, idx = c(region = "state", "year"), position = 3, name = "index")
mn2 <- unfold_idx(mn)
attr(mn, "ids")
mn3 <- fold_idx(mn2)
identical(mn, mn3)
}
\author{
Yves Croissant
}
