% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_helpers.R
\name{formatC_mod}
\alias{formatC_mod}
\title{Modified formatC with Improved Zero and Exponential Handling}
\usage{
formatC_mod(x, digits = NULL, format = NULL, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{digits}{Integer; desired number of digits.}

\item{format}{Character string specifying the output format; see \code{\link[base]{formatC}}. Common are "fg" (significant digits), or "f" (fixed).}

\item{...}{Further arguments passed to \code{\link[base]{formatC}}.}
}
\value{
A character vector with formatted numbers.
}
\description{
Formats a numeric vector similar to \code{formatC}, but tweaks output for certain special cases:
- Attempts to remove trailing decimal points for whole numbers.
- If format is 'fg' and output is "0", falls back to fixed format (\code{f}).
- Converts exponential notation to plain numbers where appropriate.
}
\examples{
formatC_mod(c(3.14159, 42, 0), digits = 2, format = "fg")
formatC_mod(c(1e-6, 42), digits = 2, format = "fg")
}
