% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{desc_tests}
\alias{desc_tests}
\title{Add tests to a desc_table}
\usage{
desc_tests(desctable, .auto = tests_auto, .default = NULL, ...)
}
\arguments{
\item{desctable}{A desc_table}

\item{.auto}{A function to automatically determine the appropriate tests}

\item{.default}{A default fallback test}

\item{...}{A list of statistical tests associated to variable names}
}
\value{
A desc_table with tests
}
\description{
Add test statistics to a grouped desc_table, with the tests specified as \code{variable = test}.
}
\section{Tests}{

The statistical test functions to use in the table are passed as additional named arguments. Tests must be preceded
by a formula tilde (\code{~}).
\code{name = ~test} will apply test \code{test} to variable \code{name}.

Any R test function can be used, as long as it returns an object containing a \code{p.value} element, which is the
case for most tests returning an object of class  \code{htest}.

Users can also use \code{purrr::map}-like formulas as quick anonymous functions (eg. \code{~ t.test(., var.equal = T)} to
compute a t test without the Welch correction.
}

\examples{
iris \%>\%
  group_by(Species) \%>\%
  desc_table() \%>\%
  desc_tests(Sepal.Length = ~kruskal.test,
             Sepal.Width  = ~oneway.test,
             Petal.Length = ~oneway.test(., var.equal = T),
             Petal.Length = ~oneway.test(., var.equal = F))
}
\seealso{
\code{\link{tests_auto}}

\code{\link{no.test}}

\code{\link{ANOVA}}

Other desc_table core functions: 
\code{\link{desc_output}()},
\code{\link{desc_table}()}
}
\concept{desc_table core functions}
